<!-- index.php -->
<?php
// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once 'connection.php';

$error = '';
$success = '';

// Handle resume session form
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['resume_session'])) {
    $nama_lengkap = $_POST['nama_lengkap'];
    $umur = $_POST['umur'];
    
    // Check if pelamar exists in database
    $stmt = $conn->prepare("SELECT id, nama_lengkap FROM pelamar WHERE nama_lengkap = ? AND umur = ?");
    $stmt->bind_param("si", $nama_lengkap, $umur);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $_SESSION['pelamar_id'] = $row['id'];
        $_SESSION['nama_lengkap'] = $row['nama_lengkap'];
        
        // Redirect to resume the test
        header("Location: test_pelamar.php");
        exit;
    } else {
        $error = "Nama atau umur tidak ditemukan. Silakan periksa kembali.";
    }
    
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Rekrutmen</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
        }
        .container {
            background-color: white;
            padding: 30px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 100%;
        }
        h1 {
            color: #333;
        }
        p {
            color: #666;
            margin-bottom: 25px;
        }
        .btn-container {
            display: flex;
            justify-content: center;
            gap: 20px;
        }
        .btn {
            display: inline-block;
            background-color: #4CAF50;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            transition: background-color 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #45a049;
        }
        .btn-admin {
            background-color: #2196F3;
        }
        .btn-admin:hover {
            background-color: #0b7dda;
        }
        .btn-continue {
            background-color: #ff9800;
        }
        .btn-continue:hover {
            background-color: #e68a00;
        }
        .btn-new {
            background-color: #4CAF50;
        }
        .btn-new:hover {
            background-color: #45a049;
        }
        .info-box {
            background-color: #fff3e0;
            border-left: 4px solid #ff9800;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 14px;
            text-align: left;
        }
        .info-box h3 {
            margin-top: 0;
            color: #ff9800;
        }
        .info-box ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        .info-box li {
            margin-bottom: 5px;
        }
        .error {
            color: red;
            margin-bottom: 15px;
        }
        .success {
            color: green;
            margin-bottom: 15px;
        }
        
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.4);
        }
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 400px;
            border-radius: 5px;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
        }
        input[type="text"],
        input[type="number"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Selamat Datang di Sistem Rekrutmen</h1>
        
        <?php if (!empty($error)): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if (!empty($success)): ?>
            <div class="success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="info-box">
            <h3>Perhatian!</h3>
            <p>Selama mengerjakan tes, Anda diharapkan untuk:</p>
            <ul>
                <li>Tidak menggunakan bantuan dari AI seperti ChatGPT, Claude, Gemini, atau AI lainnya</li>
                <li>Tidak melakukan copy-paste kode secara berlebihan</li>
                <li>Tidak membuka media sosial selama tes berlangsung</li>
                <li>Total waktu pengerjaan adalah 45 menit untuk semua tugas</li>
            </ul>
            <p>Semua aktivitas browser Anda akan dipantau selama tes berlangsung untuk memastikan keadilan dalam proses rekrutmen.</p>
        </div>
        
        <p>Silakan pilih opsi di bawah ini untuk melanjutkan:</p>
        
        <div class="btn-container">
            <button id="startTestBtn" class="btn">Mulai Tes Pelamar</button>
            <a href="#" class="btn btn-admin">Login Admin</a>
        </div>
    </div>
    
    <!-- Modal for choosing New or Continue -->
    <div id="testOptionsModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Pilih Opsi</h2>
            <p>Apakah Anda ingin melanjutkan tes sebelumnya atau memulai tes baru?</p>
            <div class="btn-container" style="margin-top: 20px;">
                <button id="continueTestBtn" class="btn btn-continue">Melanjutkan</button>
                <a href="test_pelamar.php" class="btn btn-new">Baru</a>
            </div>
        </div>
    </div>
    
    <!-- Modal for resuming session -->
    <div id="resumeSessionModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Lanjutkan Sesi Tes</h2>
            <p>Masukkan nama lengkap dan umur Anda untuk melanjutkan tes:</p>
            
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="form-group">
                    <label for="nama_lengkap">Nama Lengkap:</label>
                    <input type="text" id="nama_lengkap" name="nama_lengkap" required>
                </div>
                
                <div class="form-group">
                    <label for="umur">Umur:</label>
                    <input type="number" id="umur" name="umur" min="15" max="100" required>
                </div>
                
                <button type="submit" name="resume_session" class="btn">Go</button>
            </form>
        </div>
    </div>
    
    <!-- Browser monitoring script -->
    <script>
        // Get modal elements
        var testOptionsModal = document.getElementById("testOptionsModal");
        var resumeSessionModal = document.getElementById("resumeSessionModal");
        
        // Get the button that opens the modal
        var startTestBtn = document.getElementById("startTestBtn");
        var continueTestBtn = document.getElementById("continueTestBtn");
        
        // Get the <span> elements that close the modals
        var spans = document.getElementsByClassName("close");
        
        // When the user clicks the button, open the testOptionsModal
        startTestBtn.onclick = function() {
            testOptionsModal.style.display = "block";
        }
        
        // When the user clicks on the Continue button, open the resumeSessionModal
        continueTestBtn.onclick = function() {
            testOptionsModal.style.display = "none";
            resumeSessionModal.style.display = "block";
        }
        
        // When the user clicks on <span> (x), close the corresponding modal
        for (var i = 0; i < spans.length; i++) {
            spans[i].onclick = function() {
                testOptionsModal.style.display = "none";
                resumeSessionModal.style.display = "none";
            }
        }
        
        // When the user clicks anywhere outside of the modals, close them
        window.onclick = function(event) {
            if (event.target == testOptionsModal) {
                testOptionsModal.style.display = "none";
            }
            if (event.target == resumeSessionModal) {
                resumeSessionModal.style.display = "none";
            }
        }
        
        // Check browser compatibility
        function checkBrowserCompatibility() {
            // Check if browser allows localStorage for session management
            try {
                localStorage.setItem('test', 'test');
                localStorage.removeItem('test');
            } catch (e) {
                console.warn('Browser tidak mendukung penyimpanan lokal. Fungsi sesi mungkin terganggu.');
            }
            
            // Check if browser allows visibilityState API for tab monitoring
            if (typeof document.hidden === "undefined") {
                console.warn('Browser tidak mendukung Visibility API. Pemantauan tab mungkin terganggu.');
            }
        }
        
        // Run compatibility check when page loads
        window.addEventListener('load', checkBrowserCompatibility);
    </script>
</body>
</html>