<?php
// Database configuration
$servername = "localhost";
$username = "kmir2197_test";
$password = "TestRecruitment";
$dbname = "kmir2197_test";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set character set to UTF-8
$conn->set_charset("utf8");

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Function to record cheating attempt - only record legitimate cheating
function recordCheating($conn, $id_pelamar, $task_type, $cheat_type, $details = null) {
    // Don't record everything as cheating - only significant issues
    // For example, don't record brief tab switching or normal copy/paste within the app
    
    // Determine if this is a serious cheating attempt that should be recorded
    $is_serious_cheating = false;
    
    // Check if this is AI-related content
    if (strpos($cheat_type, 'AI Usage') !== false || 
        strpos($details, 'chatgpt') !== false || 
        strpos($details, 'chatbot') !== false ||
        strpos($details, 'claude') !== false ||
        strpos($details, 'gemini') !== false) {
        $is_serious_cheating = true;
    }
    
    // Check if this involves extended tab switching
    if (strpos($cheat_type, 'Tab Hidden') !== false && 
        strpos($details, 'seconds') !== false) {
        // Extract the number of seconds
        preg_match('/(\d+) seconds/', $details, $matches);
        if (isset($matches[1]) && intval($matches[1]) > 10) {
            $is_serious_cheating = true;
        }
    }
    
    // Check if this involves large code pastes from external sources
    if (strpos($cheat_type, 'Large Code Paste') !== false) {
        $is_serious_cheating = true;
    }
    
    // Check if this is a social media site visit
    if (strpos($cheat_type, 'Social Media') !== false) {
        $is_serious_cheating = true;
    }

    // Only record if it's serious cheating
    if ($is_serious_cheating) {
        // Prepare SQL statement
        $stmt = $conn->prepare("INSERT INTO cheat_detection (id_pelamar, task_type, cheat_type, details) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $id_pelamar, $task_type, $cheat_type, $details);
        $stmt->execute();
        $stmt->close();
    }
}

// Function to start task timer
function startTaskTimer($conn, $id_pelamar, $task_type) {
    // Only start a global timer if it doesn't exist yet
    if (!isset($_SESSION['global_test_start_time'])) {
        $_SESSION['global_test_start_time'] = time();
        
        // Update the database with the start time for this specific task
        $column = $task_type . "_start";
        $stmt = $conn->prepare("UPDATE hasil_tes SET $column = NOW(), global_start_time = NOW() WHERE id_pelamar = ?");
        $stmt->bind_param("i", $id_pelamar);
        $stmt->execute();
        $stmt->close();
    } else {
        // Just update the task-specific start time in the database
        $column = $task_type . "_start";
        $stmt = $conn->prepare("UPDATE hasil_tes SET $column = NOW() WHERE id_pelamar = ?");
        $stmt->bind_param("i", $id_pelamar);
        $stmt->execute();
        $stmt->close();
    }
    
    // Set current task in session for tracking
    $_SESSION['current_task_type'] = $task_type;
}

// Function to end task timer
function endTaskTimer($conn, $id_pelamar, $task_type) {
    $column = $task_type . "_end";
    $stmt = $conn->prepare("UPDATE hasil_tes SET $column = NOW() WHERE id_pelamar = ?");
    $stmt->bind_param("i", $id_pelamar);
    $stmt->execute();
    $stmt->close();
    
    // Note: We don't clear the global timer, just mark the end time for this task
}

// Function to check if time limit is exceeded for the entire test
function isTimeLimitExceeded($task_type) {
    // 45 minutes in seconds (15 minutes for each of the 3 tasks)
    $total_time_limit = 45 * 60;
    
    // Get start time from session
    if (isset($_SESSION['global_test_start_time'])) {
        $start_time = $_SESSION['global_test_start_time'];
        $current_time = time();
        $elapsed_time = $current_time - $start_time;
        
        return $elapsed_time >= $total_time_limit;
    }
    
    return false;
}

// Function to get remaining time in seconds based on global timer
function getRemainingTime($task_type) {
    // 45 minutes in seconds (15 minutes for each of the 3 tasks)
    $total_time_limit = 45 * 60;
    
    // Get global start time from session
    if (isset($_SESSION['global_test_start_time'])) {
        $start_time = $_SESSION['global_test_start_time'];
        $current_time = time();
        $elapsed_time = $current_time - $start_time;
        
        $remaining_time = $total_time_limit - $elapsed_time;
        return ($remaining_time > 0) ? $remaining_time : 0;
    }
    
    return $total_time_limit;
}

// Function to check if task is in progress
function isTaskInProgress($task_type) {
    return isset($_SESSION['current_task_type']) && $_SESSION['current_task_type'] == $task_type;
}
?>