<?php
// Script untuk menambahkan admin dengan hash password yang benar
require_once 'connection.php';

// Hapus tabel admin jika perlu
$conn->query("DROP TABLE IF EXISTS admins");

// Buat ulang tabel admin
$conn->query("CREATE TABLE admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL, 
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    is_active BOOLEAN DEFAULT TRUE,
    last_login TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)");

// Buat indeks
$conn->query("CREATE INDEX idx_admin_username ON admins(username)");
$conn->query("CREATE INDEX idx_admin_email ON admins(email)");

// Tambahkan admin dengan password yang benar
$username = 'penguji';
$password = 'penguji123';
$full_name = 'Penguji IT';
$email = 'penguji@example.com';

// Generate hash password yang valid
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// Tambahkan ke database
$stmt = $conn->prepare("INSERT INTO admins (username, password, full_name, email) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $username, $hashed_password, $full_name, $email);
$stmt->execute();

echo "Admin berhasil ditambahkan dengan username: penguji dan password: penguji123";
?>