<!-- header.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Recruitment | Job Portal Kayu Mebel Indonesia</title>
    <link rel="icon" href="../images/logo.jpg" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                    backgroundImage: {
                        'gradient-primary': 'linear-gradient(135deg, #2E7D32 0%, #1B5E20 50%, #0A3D0E 100%)',
                        'gradient-side': 'linear-gradient(225deg, #2E7D32 0%, #1B5E20 50%, #0A3D0E 100%)',
                    },
                    colors: {
                        primary: '#1B5E20',
                        secondary: '#4CAF50',  
                        tertiary: '#0A3D0E',
                        'soft-green': '#E8F5E9',
                        'medium-green': '#C8E6C9',
                        'green-dark': '#2E7D32',
                    }
                }
            }
        }
    </script>
    <style>
        /* Prevent FOUC (Flash of Unstyled Content) */
        .no-transitions {
            transition: none !important;
        }

        /* Add this class to body initially */
        body.page-loading #sidebar,
        body.page-loading #mainContent {
            transition: none !important;
        }

        /* Custom animation for floating button */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .help-center-floating {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: .5; }
        }
        
        .animate-pulse {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
        
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        
        .animate-bounce {
            animation: bounce 0.5s ease-in-out;
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: #4CAF50;
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #2E7D32;
        }

        /* Card hover effects */
        .dashboard-card {
            transition: all 0.3s ease;
        }
        
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        /* Glass effect for cards */
        .glass-effect {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        /* Badge notification */
        .badge-notification {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: #EF4444;
            color: white;
            border-radius: 9999px;
            padding: 0.15rem 0.4rem;
            font-size: 0.7rem;
            font-weight: 600;
        }
    </style>
</head>
<body class="font-poppins bg-soft-green flex h-screen page-loading">
    <!-- Sidebar -->
    <div id="sidebar" class="bg-gradient-side text-white w-64 py-4 px-6 flex flex-col transition-all duration-300 h-full shadow-lg fixed z-20">
        <div class="flex flex-col items-center mb-6">
            <!-- Logo above Admin Recruitment Panel text -->
            <div class="relative flex justify-center">
                <div class="rounded-full p-1 bg-white ring-4 ring-white">
                    <img src="../images/logo.jpg" alt="Logo" class="h-20 w-20 rounded-full object-cover">
                </div>
            </div>
            <h2 class="text-1xl font-bold mt-3">Admin Recruitment</h2>
        </div>
        <div class="flex items-center justify-end lg:hidden">
            <button id="closeSidebar" class="text-white">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="flex-1 flex flex-col">
            <!-- Main Menu -->
            <div class="mb-4">
                <div class="text-xs uppercase font-semibold text-white/70 mb-2 pl-2">Menu Utama</div>
                <ul>
                    <!-- Pengenalan -->
                    <li class="mb-1">
                        <a href="dashboard_recruitment.php" class="flex items-center py-2 px-3 rounded-lg bg-white/20 transition-colors duration-200">
                            <i class="fas fa-home w-5"></i>
                            <span class="ml-2">Pengenalan</span>
                        </a>
                    </li>
                    <!-- Posisi Pekerjaan Submenu -->
                    <li class="mb-1">
                        <div class="submenu">
                            <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                <div class="flex items-center">
                                    <i class="fas fa-briefcase w-5"></i>
                                    <span class="ml-2">Posisi Pekerjaan</span>
                                </div>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </div>
                            <ul class="pl-6 mt-1 hidden">
                                <li class="mb-1">
                                    <a href="buat_posisi_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                                        <i class="fas fa-plus w-5"></i>
                                        <span class="ml-2">Buat Posisi Baru</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="kelola_posisi_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                                        <i class="fas fa-edit w-5"></i>
                                        <span class="ml-2">Kelola Posisi</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div id="mainContent" class="flex-1 flex flex-col min-h-screen transition-all duration-300">
        <!-- Top Navigation Bar -->
        <header class="bg-white shadow-sm z-10 border-b border-green-100">
            <div class="flex items-center justify-between px-6 py-3">
                <div class="flex items-center">
                    <button id="toggleSidebar" class="text-green-800 hover:text-green-600">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-semibold ml-4 text-green-800">Dashboard Recruitment</h1>
                </div>
                
                <!-- User Profile Dropdown -->
                <div class="relative">
                    <button id="profileDropdown" class="flex items-center px-3 py-2 rounded-full bg-soft-green hover:bg-medium-green transition-colors duration-200">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-green-dark flex items-center justify-center text-white">
                                R
                            </div>
                            <span class="ml-2 font-medium text-sm text-gray-700 hidden md:block">
                                Admin Recruitment
                            </span>
                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-500"></i>
                        </div>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-20 hidden">
                        <div class="px-4 py-2 text-sm text-gray-500 border-b border-gray-200">
                            Dept. Recruitment
                        </div>
                        <a href="pengaturan_akun.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-soft-green">
                            <i class="fas fa-user mr-2 text-green-600"></i> Pengaturan Akun
                        </a>
                        <a href="ubah_kata_sandi.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-soft-green">
                            <i class="fas fa-lock mr-2 text-green-600"></i> Ubah Kata Sandi
                        </a>
                        <div class="border-t border-gray-200 my-1"></div>
                        <a href="../logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-soft-green">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
        </header>