<!-- footer.php -->
<!-- Floating Help Center Button -->
<div class="fixed bottom-6 right-6 z-50 help-center-floating">
    <a href="help_center.php" class="block relative group">
        <!-- Badge notifikasi -->
        <div class="absolute -top-2 -right-2 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center animate-pulse">?</div>
        
        <!-- Icon Container -->
        <div class="bg-white rounded-full p-3 shadow-lg border-2 border-blue-500 transition-all duration-300 hover:scale-110 flex items-center justify-center relative">
            <i class="fas fa-question-circle text-blue-600 text-xl"></i>
        </div>
        
        <!-- Tooltip -->
        <div class="absolute bottom-full right-0 mb-2 w-48 p-2 bg-gray-800 text-white text-sm rounded shadow-lg transition-opacity duration-300 opacity-0 group-hover:opacity-100 pointer-events-none">
            <div class="relative">
                Butuh bantuan? Klik untuk membuka pusat bantuan
                <!-- Panah tooltip -->
                <div class="absolute bottom-[-8px] right-3 w-4 h-4 bg-gray-800 transform rotate-45"></div>
            </div>
        </div>
    </a>
</div>

<!-- Footer -->
<footer class="bg-white border-t border-gray-200 mt-auto">
    <div class="container mx-auto px-6 py-4">
        <div class="flex flex-col md:flex-row justify-between items-center">
            <div class="text-center md:text-left mb-4 md:mb-0">
                <div class="flex items-center justify-center md:justify-start mb-2">
                    <img src="../images/logo.jpg" alt="Job Portal Logo" class="h-6 mr-2">
                    <p class="text-gray-600 text-sm">
                        Job Portal Kayu Mebel Indonesia &copy; 2025
                    </p>
                </div>
            </div>
            <div class="text-sm text-gray-500 mr-16">
                Admin IT Panel
            </div>
        </div>
    </div>
</footer>
</div>

<script>
    // Get DOM elements we'll be working with
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.getElementById('mainContent');
    const toggleSidebarBtn = document.getElementById('toggleSidebar');
    const closeSidebarBtn = document.getElementById('closeSidebar');
    
    // Track sidebar state
    let sidebarVisible = true;
    
    // Function to handle sidebar visibility
    function toggleSidebar() {
        sidebarVisible = !sidebarVisible;
        
        if (sidebarVisible) {
            // Show sidebar
            sidebar.classList.remove('-translate-x-full');
            sidebar.classList.add('translate-x-0');
            sidebar.style.width = '16rem'; // w-64 equivalent
            
            // Adjust main content
            mainContent.style.marginLeft = window.innerWidth >= 1024 ? '16rem' : '0';
            mainContent.style.width = window.innerWidth >= 1024 ? 'calc(100% - 16rem)' : '100%';
        } else {
            // Hide sidebar
            sidebar.classList.add('-translate-x-full');
            sidebar.classList.remove('translate-x-0');
            
            // Expand main content to full width
            mainContent.style.marginLeft = '0';
            mainContent.style.width = '100%';
        }
    }
    
    // Toggle sidebar button
    toggleSidebarBtn.addEventListener('click', toggleSidebar);
    
    // Close sidebar button (mobile only)
    closeSidebarBtn.addEventListener('click', function() {
        if (sidebarVisible) {
            toggleSidebar();
        }
    });
    
    // Handle window resize to adjust layout appropriately
    window.addEventListener('resize', function() {
        if (window.innerWidth >= 1024) {
            // On desktop view, adjust based on sidebar visibility
            if (sidebarVisible) {
                mainContent.style.marginLeft = '16rem';
                mainContent.style.width = 'calc(100% - 16rem)';
            } else {
                mainContent.style.marginLeft = '0';
                mainContent.style.width = '100%';
            }
        } else {
            // On mobile view
            mainContent.style.marginLeft = '0';
            mainContent.style.width = '100%';
        }
    });
    
    // Toggle profile dropdown
    document.getElementById('profileDropdown').addEventListener('click', function() {
        document.getElementById('profileMenu').classList.toggle('hidden');
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const profileDropdown = document.getElementById('profileDropdown');
        const profileMenu = document.getElementById('profileMenu');
        
        if (!profileDropdown.contains(event.target) && !profileMenu.contains(event.target)) {
            profileMenu.classList.add('hidden');
        }
    });
    
    // Track the currently open submenu
    let openSubmenu = null;
    
    // Toggle submenu with auto-close functionality
    function toggleSubmenu(element) {
        const submenu = element.nextElementSibling;
        const icon = element.querySelector('.fa-chevron-down, .fa-chevron-up');
        
        // If there's already an open submenu and it's not the one being clicked
        if (openSubmenu && openSubmenu !== submenu) {
            // Close the currently open submenu
            openSubmenu.classList.add('hidden');
            
            // Find the icon in the parent element of the open submenu and reset it
            const openSubmenuIcon = openSubmenu.previousElementSibling.querySelector('.fa-chevron-down, .fa-chevron-up');
            if (openSubmenuIcon) {
                openSubmenuIcon.classList.remove('fa-chevron-up');
                openSubmenuIcon.classList.add('fa-chevron-down');
            }
        }
        
        // Toggle the clicked submenu
        submenu.classList.toggle('hidden');
        icon.classList.toggle('fa-chevron-down');
        icon.classList.toggle('fa-chevron-up');
        
        // Update the currently open submenu reference
        if (submenu.classList.contains('hidden')) {
            openSubmenu = null;
        } else {
            openSubmenu = submenu;
        }
    }
    
    // Initialize - ensure all submenus are closed on page load
    document.addEventListener('DOMContentLoaded', function() {
        const submenus = document.querySelectorAll('.submenu > ul');
        submenus.forEach(function(submenu) {
            submenu.classList.add('hidden');
        });
        
        // Set initial sidebar state
        sidebarVisible = window.innerWidth >= 1024;
        
        // IMPORTANT: Disable transitions during initial page load
        sidebar.style.transition = 'none';
        mainContent.style.transition = 'none';
        
        // Set initial layout based on screen size
        if (window.innerWidth < 1024) {
            // On small screens, start with sidebar hidden
            sidebar.classList.add('-translate-x-full');
            sidebar.classList.remove('translate-x-0');
            mainContent.style.marginLeft = '0';
            mainContent.style.width = '100%';
            sidebarVisible = false;
        } else {
            // On larger screens, ensure proper layout
            sidebar.classList.remove('-translate-x-full');
            sidebar.classList.add('translate-x-0');
            mainContent.style.marginLeft = '16rem';
            mainContent.style.width = 'calc(100% - 16rem)';
        }
        
        // Re-enable transitions after a short delay
        setTimeout(function() {
            sidebar.style.transition = 'all 0.3s ease';
            mainContent.style.transition = 'all 0.3s ease';
        }, 50);
        
        // Initialize menu item states based on current URL
        const currentPath = window.location.pathname;
        const menuItems = document.querySelectorAll('.submenu ul li a');

        menuItems.forEach(function(item) {
            const itemHref = item.getAttribute('href');
            if (itemHref && currentPath.includes(itemHref)) {
                // This is the active menu item, open its parent submenu
                const parentSubmenu = item.closest('ul');
                const parentToggle = parentSubmenu.previousElementSibling;
                
                // Only open if it's actually hidden
                if (parentSubmenu.classList.contains('hidden')) {
                    toggleSubmenu(parentToggle);
                }
                
                // Add active class to the menu item
                item.classList.add('bg-white/20');
            }
        });

        // Add smooth transitions to cards
        const cards = document.querySelectorAll('.dashboard-card');
        cards.forEach(card => {
            card.addEventListener('mouseenter', () => {
                card.style.transform = 'translateY(-5px)';
                card.style.boxShadow = '0 10px 25px rgba(0, 0, 0, 0.1)';
            });
            
            card.addEventListener('mouseleave', () => {
                card.style.transform = 'translateY(0)';
                card.style.boxShadow = '0 4px 6px rgba(0, 0, 0, 0.1)';
            });
        });

        // Welcome toast removed from here - now only shows in dashboard_it.php after login
    });
    
    // Remove page-loading class after page is fully loaded
    window.addEventListener('load', function() {
        document.body.classList.remove('page-loading');
    });
    
    // Toast notification function (kept for use by individual pages)
    function showToast(message, type = 'success') {
        const toast = document.createElement('div');
        toast.className = `fixed top-4 right-4 px-4 py-2 rounded-lg shadow-lg z-50 ${
            type === 'success' ? 'bg-blue-500' : 
            type === 'error' ? 'bg-red-500' : 
            type === 'warning' ? 'bg-amber-500' : 'bg-blue-500'
        } text-white flex items-center`;
        
        const icon = document.createElement('i');
        icon.className = `mr-2 ${
            type === 'success' ? 'fas fa-check-circle' : 
            type === 'error' ? 'fas fa-exclamation-circle' : 
            type === 'warning' ? 'fas fa-exclamation-triangle' : 'fas fa-info-circle'
        }`;
        
        const text = document.createElement('span');
        text.textContent = message;
        
        toast.appendChild(icon);
        toast.appendChild(text);
        document.body.appendChild(toast);
        
        // Animate in
        toast.style.opacity = '0';
        toast.style.transform = 'translateY(-20px)';
        toast.style.transition = 'all 0.3s ease';
        
        setTimeout(() => {
            toast.style.opacity = '1';
            toast.style.transform = 'translateY(0)';
        }, 10);
        
        // Remove after 3 seconds
        setTimeout(() => {
            toast.style.opacity = '0';
            toast.style.transform = 'translateY(-20px)';
            setTimeout(() => {
                document.body.removeChild(toast);
            }, 300);
        }, 300);
    }
</script>
</body>
</html>