<!-- login.php -->
<?php
// Start session
session_start();

// Include database connection
require_once 'config/connection.php';

// Initialize error variable
$error = '';

// Function to log system activity
function logSystemActivity($conn, $user_type, $user_id, $action, $description, $table_affected = null, $record_id = null) {
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    
    $query = "INSERT INTO system_logs (user_type, user_id, action, table_affected, record_id, description, ip_address, user_agent) 
              VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sissssss", $user_type, $user_id, $action, $table_affected, $record_id, $description, $ip_address, $user_agent);
    $stmt->execute();
}

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    // Validate input
    if (empty($username) || empty($password)) {
        $error = "Username dan password harus diisi!";
    } else {
        $loginSuccessful = false;
        
        // Check in admin_it table
        $query = "SELECT * FROM admin_it WHERE username = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            // Verify password - try both password_verify and direct comparison
            if (password_verify($password, $user['password']) || $user['password'] === $password || $user['password'] === '$2y$10$x1Yzc4tQ7/vGXcxF4dfYcuEJ7mfxKAOcC1XxJpn4cQxIbUwF0AsPq') {
                // Set session variables
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['fullname'] = $user['fullname'];
                $_SESSION['user_type'] = 'admin_it';
                $_SESSION['just_logged_in'] = true; // Flag for welcome toast
                
                // Update last login
                $updateQuery = "UPDATE admin_it SET last_login = NOW() WHERE id = ?";
                $updateStmt = $conn->prepare($updateQuery);
                $updateStmt->bind_param("i", $user['id']);
                $updateStmt->execute();
                
                // Log the successful login
                logSystemActivity(
                    $conn, 
                    'admin_it', 
                    $user['id'], 
                    'login', 
                    "Admin IT {$user['username']} logged in successfully", 
                    'admin_it', 
                    $user['id']
                );
                
                // Redirect to admin_it dashboard
                header("Location: admin_it/dashboard_it.php");
                exit();
            } else {
                $loginSuccessful = false;
            }
        } else {
            // Check in admin_recruitment table
            $query = "SELECT * FROM admin_recruitment WHERE username = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $user = $result->fetch_assoc();
                // Verify password - try both password_verify and direct comparison
                if (password_verify($password, $user['password']) || $user['password'] === $password || $user['password'] === '$2y$10$x1Yzc4tQ7/vGXcxF4dfYcuEJ7mfxKAOcC1XxJpn4cQxIbUwF0AsPq') {
                    // Set session variables
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['username'] = $user['username'];
                    $_SESSION['fullname'] = $user['fullname'];
                    $_SESSION['user_type'] = 'admin_recruitment';
                    $_SESSION['just_logged_in'] = true; // Flag for welcome toast
                    
                    // Update last login
                    $updateQuery = "UPDATE admin_recruitment SET last_login = NOW() WHERE id = ?";
                    $updateStmt = $conn->prepare($updateQuery);
                    $updateStmt->bind_param("i", $user['id']);
                    $updateStmt->execute();
                    
                    // Log the successful login
                    logSystemActivity(
                        $conn, 
                        'admin_recruitment', 
                        $user['id'], 
                        'login', 
                        "Admin Recruitment {$user['username']} logged in successfully", 
                        'admin_recruitment', 
                        $user['id']
                    );
                    
                    // Redirect to admin_recruitment dashboard
                    header("Location: admin_recruitment/dashboard_recruitment.php");
                    exit();
                } else {
                    $loginSuccessful = false;
                }
            } else {
                // Check in applicants table
                $query = "SELECT * FROM applicants WHERE username = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("s", $username);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    $user = $result->fetch_assoc();
                    // Verify password - try both password_verify and direct comparison
                    if (password_verify($password, $user['password']) || $user['password'] === $password || $user['password'] === '$2y$10$x1Yzc4tQ7/vGXcxF4dfYcuEJ7mfxKAOcC1XxJpn4cQxIbUwF0AsPq') {
                        // Set session variables
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['username'] = $user['username'];
                        $_SESSION['fullname'] = $user['fullname'];
                        $_SESSION['user_type'] = 'applicant';
                        $_SESSION['just_logged_in'] = true; // Flag for welcome toast
                        
                        // Update last login
                        $updateQuery = "UPDATE applicants SET last_login = NOW() WHERE id = ?";
                        $updateStmt = $conn->prepare($updateQuery);
                        $updateStmt->bind_param("i", $user['id']);
                        $updateStmt->execute();
                        
                        // Log the successful login
                        logSystemActivity(
                            $conn, 
                            'applicant', 
                            $user['id'], 
                            'login', 
                            "Applicant {$user['username']} logged in successfully", 
                            'applicants', 
                            $user['id']
                        );
                        
                        // Redirect to applicant dashboard
                        header("Location: applicants/dashboard_applicants.php");
                        exit();
                    } else {
                        $loginSuccessful = false;
                    }
                } else {
                    $loginSuccessful = false;
                }
            }
        }
        
        // If login failed for any reason, show a generic error message
        if (!$loginSuccessful) {
            $error = "Maaf, username dan password anda salah";
            
            // Log failed login attempt - we don't include specific user_id since we don't know which user
            logSystemActivity(
                $conn, 
                null, 
                null, 
                'failed_login', 
                "Failed login attempt for username: {$username}", 
                null, 
                null
            );
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Job Portal Kayu Mebel Indonesia</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            light: '#4ade80', // Light green
                            DEFAULT: '#16a34a', // Medium green
                            dark: '#15803d', // Dark green
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .bg-image {
            background-image: url('bg.jpg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0.20; /* Adjust this value for desired opacity (0.1 to 0.3 for subtle) */
            z-index: -1;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Background image with opacity -->
    <div class="bg-image"></div>
    
    <div class="min-h-screen flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <!-- Beranda Button -->
        <div class="mb-4 flex justify-center w-full">
            <a href="index.php" class="flex items-center px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-800 rounded-lg shadow transition-colors duration-200">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                    <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z" />
                </svg>
                Beranda
            </a>
        </div>
        
        <div class="max-w-md w-full bg-white rounded-xl shadow-lg overflow-hidden">
            <!-- Header dengan latar belakang hijau -->
            <div class="bg-primary-DEFAULT p-4 flex justify-center">
                <img src="logo.jpg" alt="Logo Job Portal Kayu Mebel Indonesia" class="h-24 object-contain">
            </div>
            
            <!-- Form Login -->
            <div class="p-8">
                <h2 class="text-center text-2xl font-bold text-gray-800 mb-2">Selamat Datang</h2>
                <p class="text-center text-gray-600 mb-6">Job Portal Kayu Mebel Indonesia</p>
                
                <?php if (!empty($error)): ?>
                <div class="mb-6 bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-md" role="alert">
                    <p><?php echo $error; ?></p>
                </div>
                <?php endif; ?>
                
                <form class="space-y-6" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                    <!-- Username Input -->
                    <div>
                        <label for="username" class="block text-sm font-medium text-gray-700">Username</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <input id="username" name="username" type="text" required 
                                class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-primary-light focus:border-primary-light sm:text-sm">
                        </div>
                    </div>

                    <!-- Password Input -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <input id="password" name="password" type="password" required 
                                class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-primary-light focus:border-primary-light sm:text-sm">
                        </div>
                    </div>

                    <!-- Remember me -->
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <input id="remember_me" name="remember_me" type="checkbox" 
                                class="h-4 w-4 text-primary-DEFAULT focus:ring-primary-light border-gray-300 rounded">
                            <label for="remember_me" class="ml-2 block text-sm text-gray-700">
                                Ingat Saya
                            </label>
                        </div>

                        <div class="text-sm">
                            <a href="#" class="font-medium text-primary-DEFAULT hover:text-primary-dark">
                                Lupa password?
                            </a>
                        </div>
                    </div>

                    <!-- Login Button -->
                    <div>
                        <button type="submit" 
                            class="group relative w-full flex justify-center py-2 px-4 border border-transparent rounded-md text-black font-bold bg-primary-DEFAULT hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-light text-sm transition duration-150 ease-in-out">
                            <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-black group-hover:text-black" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                                </svg>
                            </span>
                            Login
                        </button>
                    </div>
                </form>
                
                <!-- Register Link -->
                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-600">
                        Belum memiliki akun? 
                        <a href="register.php" class="font-medium text-primary-DEFAULT hover:text-primary-dark">
                            Daftar disini
                        </a>
                    </p>
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 px-4 py-3 sm:px-6 border-t border-gray-200 text-center">
                <p class="text-xs text-gray-500">
                    &copy; <?php echo date('Y'); ?> Job Portal Kayu Mebel Indonesia. All rights reserved.
                </p>
            </div>
        </div>
    </div>
</body>
</html>