<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pelamar Kerja</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .transition-width {
            transition: width 0.3s ease-in-out;
        }
        .transition-margin {
            transition: margin-left 0.3s ease-in-out;
        }
        .dropdown {
            display: none;
            position: absolute;
            right: 0;
            top: 100%;
            z-index: 10;
        }
        .dropdown.show {
            display: block;
        }
        .sub-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
        }
        .sub-menu.active {
            max-height: 500px;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div id="sidebar" class="bg-blue-800 text-white w-64 transition-width flex-shrink-0">
            <!-- Logo -->
            <div class="flex items-center justify-center h-16 border-b border-blue-700">
                <h1 class="text-xl font-bold">JobSeeker Pro</h1>
            </div>
            
            <!-- Menu -->
            <div class="py-4 overflow-y-auto">
                <ul class="space-y-2 px-3">
                    <li>
                        <a href="#" class="flex items-center p-2 rounded-lg hover:bg-blue-700 group">
                            <i class="fas fa-tachometer-alt w-6 text-gray-300 group-hover:text-white"></i>
                            <span class="ml-3">Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <div class="menu-item">
                            <button class="flex items-center justify-between w-full p-2 rounded-lg hover:bg-blue-700 group">
                                <div class="flex items-center">
                                    <i class="fas fa-briefcase w-6 text-gray-300 group-hover:text-white"></i>
                                    <span class="ml-3">Lowongan Kerja</span>
                                </div>
                                <i class="fas fa-chevron-down text-sm"></i>
                            </button>
                            <ul class="sub-menu ml-8 mt-1">
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        Lowongan Tersedia
                                    </a>
                                </li>
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        Lowongan Dilamar
                                    </a>
                                </li>
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        Rekomendasi
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <div class="menu-item">
                            <button class="flex items-center justify-between w-full p-2 rounded-lg hover:bg-blue-700 group">
                                <div class="flex items-center">
                                    <i class="fas fa-file-alt w-6 text-gray-300 group-hover:text-white"></i>
                                    <span class="ml-3">Dokumen</span>
                                </div>
                                <i class="fas fa-chevron-down text-sm"></i>
                            </button>
                            <ul class="sub-menu ml-8 mt-1">
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        CV & Resume
                                    </a>
                                </li>
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        Sertifikat
                                    </a>
                                </li>
                                <li>
                                    <a href="#" class="flex p-2 text-sm text-gray-300 hover:text-white rounded-lg hover:bg-blue-700">
                                        Dokumen Lainnya
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 rounded-lg hover:bg-blue-700 group">
                            <i class="fas fa-calendar-alt w-6 text-gray-300 group-hover:text-white"></i>
                            <span class="ml-3">Jadwal Interview</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 rounded-lg hover:bg-blue-700 group">
                            <i class="fas fa-bell w-6 text-gray-300 group-hover:text-white"></i>
                            <span class="ml-3">Notifikasi</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 rounded-lg hover:bg-blue-700 group">
                            <i class="fas fa-cog w-6 text-gray-300 group-hover:text-white"></i>
                            <span class="ml-3">Pengaturan</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Main Content -->
        <div id="content" class="flex-1 overflow-auto transition-margin">
            <!-- Navbar -->
            <nav class="bg-white shadow-md p-4 flex justify-between items-center">
                <div class="flex items-center">
                    <button id="toggle-sidebar" class="p-2 mr-3 rounded-md hover:bg-gray-200">
                        <i class="fas fa-bars text-gray-600"></i>
                    </button>
                    <h2 class="text-xl font-semibold text-gray-700">Dashboard</h2>
                </div>
                
                <!-- Profile Dropdown -->
                <div class="relative">
                    <button id="profile-button" class="flex items-center space-x-3 focus:outline-none">
                        <div class="text-right mr-2">
                            <p class="text-sm font-medium text-gray-700">Ahmad Rifai</p>
                            <p class="text-xs text-gray-500">Pelamar</p>
                        </div>
                        <img class="h-10 w-10 rounded-full border-2 border-blue-500" src="/api/placeholder/40/40" alt="Profile Image">
                        <i class="fas fa-chevron-down text-gray-500 text-xs"></i>
                    </button>
                    
                    <div id="profile-dropdown" class="dropdown bg-white rounded-md shadow-lg py-2 w-48 mt-1 border border-gray-200">
                        <a href="#" class="block px-4 py-2 text-gray-700 hover:bg-blue-50">
                            <i class="fas fa-user mr-2"></i> Profile
                        </a>
                        <a href="#" class="block px-4 py-2 text-gray-700 hover:bg-blue-50">
                            <i class="fas fa-key mr-2"></i> Ubah Password
                        </a>
                        <div class="border-t border-gray-200 my-1"></div>
                        <a href="#" class="block px-4 py-2 text-red-600 hover:bg-red-50">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </nav>
            
            <!-- Dashboard Content -->
            <div class="p-6">
                <!-- Welcome Banner -->
                <div class="bg-gradient-to-r from-blue-500 to-blue-700 rounded-lg p-6 mb-6 shadow-md text-white">
                    <h2 class="text-2xl font-bold mb-2">Selamat Datang, Ahmad!</h2>
                    <p class="mb-4">Anda memiliki 3 lamaran yang sedang diproses dan 2 tawaran interview minggu ini.</p>
                    <button class="bg-white text-blue-600 px-4 py-2 rounded-md font-medium hover:bg-blue-50">Lihat Detail</button>
                </div>
                
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                    <div class="bg-white rounded-lg p-6 shadow-sm border border-gray-200">
                        <div class="flex justify-between">
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Lamaran Terkirim</p>
                                <h3 class="text-2xl font-bold text-gray-800">12</h3>
                            </div>
                            <div class="p-3 bg-blue-100 text-blue-600 rounded-full">
                                <i class="fas fa-paper-plane"></i>
                            </div>
                        </div>
                        <p class="text-xs text-green-600 mt-4"><i class="fas fa-arrow-up mr-1"></i> 15% dari bulan lalu</p>
                    </div>
                    
                    <div class="bg-white rounded-lg p-6 shadow-sm border border-gray-200">
                        <div class="flex justify-between">
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Interview Dijadwalkan</p>
                                <h3 class="text-2xl font-bold text-gray-800">3</h3>
                            </div>
                            <div class="p-3 bg-green-100 text-green-600 rounded-full">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                        </div>
                        <p class="text-xs text-green-600 mt-4"><i class="fas fa-arrow-up mr-1"></i> 25% dari bulan lalu</p>
                    </div>
                    
                    <div class="bg-white rounded-lg p-6 shadow-sm border border-gray-200">
                        <div class="flex justify-between">
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Lowongan Disukai</p>
                                <h3 class="text-2xl font-bold text-gray-800">25</h3>
                            </div>
                            <div class="p-3 bg-yellow-100 text-yellow-600 rounded-full">
                                <i class="fas fa-heart"></i>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500 mt-4">Sama dengan bulan lalu</p>
                    </div>
                    
                    <div class="bg-white rounded-lg p-6 shadow-sm border border-gray-200">
                        <div class="flex justify-between">
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Profil Dilihat</p>
                                <h3 class="text-2xl font-bold text-gray-800">85</h3>
                            </div>
                            <div class="p-3 bg-purple-100 text-purple-600 rounded-full">
                                <i class="fas fa-eye"></i>
                            </div>
                        </div>
                        <p class="text-xs text-green-600 mt-4"><i class="fas fa-arrow-up mr-1"></i> 32% dari bulan lalu</p>
                    </div>
                </div>
                
                <!-- Recent Applications -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 mb-6">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-lg font-semibold text-gray-800">Lamaran Terbaru</h2>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="bg-gray-50 text-left">
                                    <th class="p-4 text-sm font-medium text-gray-500">Perusahaan</th>
                                    <th class="p-4 text-sm font-medium text-gray-500">Posisi</th>
                                    <th class="p-4 text-sm font-medium text-gray-500">Tanggal Melamar</th>
                                    <th class="p-4 text-sm font-medium text-gray-500">Status</th>
                                    <th class="p-4 text-sm font-medium text-gray-500">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-b border-gray-200">
                                    <td class="p-4">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 rounded bg-gray-200 flex items-center justify-center text-gray-500">PT</div>
                                            <span class="ml-3 font-medium text-gray-700">PT Maju Bersama</span>
                                        </div>
                                    </td>
                                    <td class="p-4 text-gray-700">Front-end Developer</td>
                                    <td class="p-4 text-gray-500">12 Mei 2025</td>
                                    <td class="p-4">
                                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs">Sedang Diproses</span>
                                    </td>
                                    <td class="p-4">
                                        <button class="text-blue-600 hover:text-blue-800">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr class="border-b border-gray-200">
                                    <td class="p-4">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 rounded bg-gray-200 flex items-center justify-center text-gray-500">TI</div>
                                            <span class="ml-3 font-medium text-gray-700">Tech Innovations</span>
                                        </div>
                                    </td>
                                    <td class="p-4 text-gray-700">UI/UX Designer</td>
                                    <td class="p-4 text-gray-500">10 Mei 2025</td>
                                    <td class="p-4">
                                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Interview</span>
                                    </td>
                                    <td class="p-4">
                                        <button class="text-blue-600 hover:text-blue-800">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-4">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 rounded bg-gray-200 flex items-center justify-center text-gray-500">GS</div>
                                            <span class="ml-3 font-medium text-gray-700">Global Systems</span>
                                        </div>
                                    </td>
                                    <td class="p-4 text-gray-700">Full-stack Developer</td>
                                    <td class="p-4 text-gray-500">5 Mei 2025</td>
                                    <td class="p-4">
                                        <span class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs">Ditolak</span>
                                    </td>
                                    <td class="p-4">
                                        <button class="text-blue-600 hover:text-blue-800">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Upcoming Interviews -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                    <div class="p-6 border-b border-gray-200">
                        <h2 class="text-lg font-semibold text-gray-800">Jadwal Interview</h2>
                    </div>
                    <div class="p-6">
                        <div class="space-y-4">
                            <div class="flex items-start border-l-4 border-green-500 pl-4">
                                <div class="bg-green-100 text-green-600 rounded-full h-12 w-12 flex items-center justify-center mr-4 flex-shrink-0">
                                    <i class="fas fa-video"></i>
                                </div>
                                <div>
                                    <h3 class="font-medium text-gray-800">Tech Innovations - UI/UX Designer</h3>
                                    <p class="text-gray-500 text-sm">14 Mei 2025, 10:00 - 11:00</p>
                                    <p class="text-gray-500 text-sm mt-1">Interview Online (Zoom)</p>
                                    <div class="mt-2">
                                        <button class="text-blue-600 text-sm hover:underline mr-4">
                                            <i class="fas fa-link mr-1"></i> Join Meeting
                                        </button>
                                        <button class="text-gray-600 text-sm hover:underline">
                                            <i class="fas fa-calendar-alt mr-1"></i> Tambah ke Kalender
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="flex items-start border-l-4 border-blue-500 pl-4">
                                <div class="bg-blue-100 text-blue-600 rounded-full h-12 w-12 flex items-center justify-center mr-4 flex-shrink-0">
                                    <i class="fas fa-building"></i>
                                </div>
                                <div>
                                    <h3 class="font-medium text-gray-800">PT Teknologi Indonesia - Web Developer</h3>
                                    <p class="text-gray-500 text-sm">16 Mei 2025, 13:00 - 14:30</p>
                                    <p class="text-gray-500 text-sm mt-1">Interview Tatap Muka (Jakarta Office)</p>
                                    <div class="mt-2">
                                        <button class="text-blue-600 text-sm hover:underline mr-4">
                                            <i class="fas fa-map-marker-alt mr-1"></i> Lihat Lokasi
                                        </button>
                                        <button class="text-gray-600 text-sm hover:underline">
                                            <i class="fas fa-calendar-alt mr-1"></i> Tambah ke Kalender
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Sidebar Toggle
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');
        const toggleBtn = document.getElementById('toggle-sidebar');
        
        toggleBtn.addEventListener('click', () => {
            if (sidebar.classList.contains('w-64')) {
                sidebar.classList.remove('w-64');
                sidebar.classList.add('w-0');
                content.classList.add('ml-0');
            } else {
                sidebar.classList.remove('w-0');
                sidebar.classList.add('w-64');
                content.classList.remove('ml-0');
            }
        });
        
        // Profile Dropdown
        const profileBtn = document.getElementById('profile-button');
        const profileDropdown = document.getElementById('profile-dropdown');
        
        profileBtn.addEventListener('click', () => {
            profileDropdown.classList.toggle('show');
        });
        
        // Close the dropdown when clicking outside
        window.addEventListener('click', (event) => {
            if (!profileBtn.contains(event.target) && !profileDropdown.contains(event.target)) {
                profileDropdown.classList.remove('show');
            }
        });
        
        // Submenu Toggle
        const menuItems = document.querySelectorAll('.menu-item');
        
        menuItems.forEach(item => {
            const button = item.querySelector('button');
            const subMenu = item.querySelector('.sub-menu');
            
            button.addEventListener('click', () => {
                subMenu.classList.toggle('active');
                const icon = button.querySelector('.fa-chevron-down');
                icon.classList.toggle('fa-chevron-up');
            });
        });
        
        // Responsive behavior for small screens
        function checkScreenSize() {
            if (window.innerWidth < 768) {
                sidebar.classList.remove('w-64');
                sidebar.classList.add('w-0');
                content.classList.add('ml-0');
            } else {
                sidebar.classList.remove('w-0');
                sidebar.classList.add('w-64');
                content.classList.remove('ml-0');
            }
        }
        
        // Check on load and resize
        window.addEventListener('resize', checkScreenSize);
        checkScreenSize(); // Initial check
    </script>
</body>
</html>