<?php
// Include database connection
require_once 'config/connection.php';

// Process feedback form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_feedback'])) {
    // Sanitize inputs
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $message = mysqli_real_escape_string($conn, $_POST['message']);
    
    // Get IP address
    $ip_address = $_SERVER['REMOTE_ADDR'];
    
    // Insert into database
    $query = "INSERT INTO website_feedback (name, email, message, ip_address) 
              VALUES ('$name', '$email', '$message', '$ip_address')";
    
    $result = mysqli_query($conn, $query);
    
    if ($result) {
        $feedback_success = true;
    } else {
        $feedback_error = "Terjadi kesalahan: " . mysqli_error($conn);
    }
}

// Fetch FAQs from database
$faq_query = "SELECT * FROM faq WHERE is_published = 1 ORDER BY display_order ASC";
$faq_result = mysqli_query($conn, $faq_query);
$faqs = [];

if (mysqli_num_rows($faq_result) > 0) {
    while ($row = mysqli_fetch_assoc($faq_result)) {
        $faqs[] = $row;
    }
}

// Fetch the secret login key
$key_query = "SELECT secret_code FROM key_login LIMIT 1";
$key_result = mysqli_query($conn, $key_query);
$secret_code = '';

if (mysqli_num_rows($key_result) > 0) {
    $key_row = mysqli_fetch_assoc($key_result);
    $secret_code = $key_row['secret_code'];
} else {
    // If no secret code exists, create one
    $default_code = 'kayu_mebel_admin_2025';
    $insert_key = "INSERT INTO key_login (secret_code) VALUES ('$default_code')";
    mysqli_query($conn, $insert_key);
    $secret_code = $default_code;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Karir Mebel Kayu Indonesia</title>
    <link rel="icon" href="images/logo.jpg" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        mebelgreen: '#4d8c61',
                        mebellight: '#f8f9fa',
                        mebeldark: '#3a6b4a'
                    },
                    fontFamily: {
                        'jakarta': ['Plus Jakarta Sans', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        html {
            scroll-behavior: smooth;
        }
        .gradient-bg {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        .card-hover {
            transition: all 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        .animate-fade-in {
            animation: fadeIn 0.6s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .home-bg {
            background-image: url('bg.jpg');
            background-size: cover;
            background-position: center;
            position: relative;
            overflow: hidden;
        }
        .home-bg::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: white;
            opacity: 0.7;
            z-index: 0;
        }
        .home-bg::after {
            content: "";
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to right, 
                rgba(255, 255, 255, 0) 0%,
                rgba(255, 255, 255, 0.3) 50%,
                rgba(255, 255, 255, 0) 100%
            );
            transform: rotate(30deg);
            animation: shine 6s infinite;
            z-index: 1;
        }
        @keyframes shine {
            0% {
                transform: translateX(-100%) rotate(30deg);
            }
            25%, 100% {
                transform: translateX(100%) rotate(30deg);
            }
        }
        .home-bg > * {
            position: relative;
            z-index: 2;
        }
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.4);
        }
        .modal-content {
            background-color: #fefefe;
            margin: 10vh auto;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.3);
            position: relative;
            max-width: 700px;
            max-height: 80vh;
            overflow-y: auto;
        }
        .close-modal {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close-modal:hover,
        .close-modal:focus {
            color: #000;
            text-decoration: none;
        }
        /* Fix for mobile header */
        @media (max-width: 768px) {
            .site-logo {
                max-width: 220px;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }
            .mobile-nav-container {
                justify-content: space-between;
                width: 100%;
            }
        }
    </style>
</head>
<body class="bg-white font-jakarta text-gray-800">
    <!-- Welcome Modal -->
    <div id="welcomeModal" class="modal">
        <div class="modal-content max-w-md">
            <span class="close-modal" onclick="closeWelcomeModal()">&times;</span>
            <div class="text-center p-2">
                <i class="fas fa-exclamation-triangle text-yellow-500 text-5xl mb-4"></i>
                <h2 class="text-xl font-bold text-gray-900 mb-3">PERINGATAN</h2>
                <p class="text-gray-700 mb-4">Cek Job Portal ini untuk melamar pekerjaan di PT. Kayu Mebel Indonesia sidoarjo-semarang.</p>
                <p class="text-gray-700 font-bold mb-4">Seluruh proses rekrutmen dan seleksi tidak dipungut biaya dan tidak melalui perantara pihak manapun.</p>
                <button onclick="closeWelcomeModal()" class="px-6 py-3 bg-mebelgreen text-white font-semibold rounded-xl hover:bg-mebeldark transition-colors duration-300">
                    Saya Mengerti
                </button>
            </div>
        </div>
    </div>

    <!-- Login Key Modal -->
    <div id="loginKeyModal" class="modal">
        <div class="modal-content max-w-md">
            <span class="close-modal" onclick="closeLoginKeyModal()">&times;</span>
            <div class="text-center p-2">
                <i class="fas fa-key text-mebelgreen text-5xl mb-4"></i>
                <h2 class="text-xl font-bold text-gray-900 mb-3">Kunci Rahasia</h2>
                <p class="text-gray-700 mb-4">Masukkan kunci rahasia untuk mengakses halaman login (hanya admin dan it yang dapat akses):</p>
                <div class="mb-4">
                    <input type="password" id="secretKey" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-mebelgreen focus:border-transparent" placeholder="Masukkan kunci rahasia">
                </div>
                <div class="text-red-500 mb-4 hidden" id="keyError">Kunci rahasia salah!</div>
                <button onclick="checkSecretKey()" class="px-6 py-3 bg-mebelgreen text-white font-semibold rounded-xl hover:bg-mebeldark transition-colors duration-300">
                    Verifikasi
                </button>
            </div>
        </div>
    </div>

    <!-- Navbar -->
    <nav class="fixed top-0 w-full bg-white/95 backdrop-blur-sm shadow-lg z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-20">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <a href="#home" class="flex items-center">
                            <img src="logo.jpg" alt="Mebel Kayu Logo" class="h-12 w-12 rounded-full mr-3">
                            <span class="font-bold text-mebelgreen text-xl site-logo">Kayu Mebel Indonesia</span>
                        </a>
                    </div>
                    <!-- Desktop Navigation -->
                    <div class="hidden md:flex items-center space-x-8 ml-8">
                        <a href="#home" class="py-5 px-3 text-mebelgreen font-medium border-b-2 border-mebelgreen transition-colors duration-200 nav-link">Home</a>
                        <a href="#about" class="py-5 px-3 text-gray-600 font-medium hover:text-mebelgreen transition-colors duration-200 nav-link">About</a>
                        <a href="#lowongan" class="py-5 px-3 text-gray-600 font-medium hover:text-mebelgreen transition-colors duration-200 nav-link">Lowongan</a>
                        <a href="#faq" class="py-5 px-3 text-gray-600 font-medium hover:text-mebelgreen transition-colors duration-200 nav-link">FAQ</a>
                        <a href="#kontak" class="py-5 px-3 text-gray-600 font-medium hover:text-mebelgreen transition-colors duration-200 nav-link">Kontak</a>
                    </div>
                </div>
                
                <!-- Login/Register buttons (Desktop) -->
                <div class="hidden md:flex items-center space-x-4">
                    <a href="#" onclick="showLoginKeyModal(); return false;" class="px-4 py-2 text-mebelgreen font-medium border border-mebelgreen rounded-lg hover:bg-mebelgreen hover:text-white transition-colors duration-200">
                        Login
                    </a>
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button class="outline-none mobile-menu-button">
                        <svg class="w-6 h-6 text-mebelgreen" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                            <path d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        <!-- Mobile Menu -->
        <div class="hidden mobile-menu md:hidden bg-white border-t border-gray-200">
            <div class="px-4 pt-2 pb-3 space-y-1">
                <a href="#home" class="block py-2 text-mebelgreen font-medium nav-link">Home</a>
                <a href="#about" class="block py-2 text-gray-600 font-medium hover:text-mebelgreen nav-link">About</a>
                <a href="#lowongan" class="block py-2 text-gray-600 font-medium hover:text-mebelgreen nav-link">Lowongan</a>
                <a href="#faq" class="block py-2 text-gray-600 font-medium hover:text-mebelgreen nav-link">FAQ</a>
                <a href="#kontak" class="block py-2 text-gray-600 font-medium hover:text-mebelgreen nav-link">Kontak</a>
                <div class="border-t border-gray-200 mt-2 pt-2">
                    <a href="#" onclick="showLoginKeyModal(); return false;" class="block py-2 text-mebelgreen font-medium">Login</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section through About Section remain unchanged -->
    <!-- Hero Section -->
    <section id="home" class="pt-32 pb-20 home-bg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="lg:grid lg:grid-cols-2 lg:gap-8 items-center">
                <div class="mb-12 lg:mb-0 animate-fade-in">
                    <h1 class="font-bold text-gray-900 leading-tight">
                        <div class="text-4xl lg:text-6xl">Bergabung Dengan Tim Kami</div>
                        <div class="text-3xl lg:text-5xl text-mebelgreen mt-2">Kembangkan Karir Di Kayu Mebel Indonesia</div>
                    </h1>
                    <p class="mt-6 text-xl text-gray-600 max-w-lg">
                        Kami mencari talenta-talenta terbaik yang passionate di bidang kerajinan kayu untuk melestarikan warisan budaya Indonesia dan menciptakan produk berkualitas global.
                    </p>
                    <div class="mt-8 flex flex-col sm:flex-row gap-4">
                        <a href="#lowongan" class="px-8 py-4 bg-mebelgreen text-white font-semibold rounded-full shadow-lg hover:bg-mebeldark hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300 nav-link text-center">
                            Lihat Lowongan
                        </a>
                        <a href="#kontak" class="px-8 py-4 border-2 border-mebelgreen text-mebelgreen font-semibold rounded-full hover:bg-mebelgreen hover:text-white transition-all duration-300 nav-link text-center">
                            Hubungi Kami
                        </a>
                    </div>
                </div>
                <div class="relative animate-fade-in">
                    <div class="relative z-10">
                        <div class="bg-white p-8 rounded-3xl shadow-2xl">
                            <div class="h-80 bg-white rounded-2xl flex items-center justify-center">
                                <img src="logo.jpg" alt="Mebel Kayu Logo" class="w-40 h-40 rounded-full">
                            </div>
                        </div>
                    </div>
                    <div class="absolute -top-4 -left-4 w-full h-full bg-mebelgreen/10 rounded-3xl"></div>
                    <div class="absolute -bottom-4 -right-4 w-full h-full bg-mebeldark/10 rounded-3xl"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl lg:text-5xl font-bold text-gray-900">
                    Tentang <span class="text-mebelgreen">Kami</span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-3xl mx-auto">
                    Kenapa bergabung dengan kami menjadi pilihan karir terbaik Anda dalam industri kerajinan kayu
                </p>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16">
                <div class="space-y-6">
                    <h3 class="text-2xl font-bold text-gray-900">Perusahaan & Budaya Kerja</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Kayu Mebel Indonesia - Adalah perusahaan dengan warisan keahlian pembuatan mebel yang telah diturunkan selama beberapa generasi. Sejak 1985, kami telah berkomitmen untuk melestarikan keahlian tradisional sambil mengadopsi teknologi modern.
                    </p>
                    <p class="text-gray-600 leading-relaxed">
                        Kami menciptakan lingkungan kerja yang mendukung kreativitas, keahlian teknis, dan pertumbuhan profesional. Setiap anggota tim dihargai karena kontribusi unik mereka, dan kami mendorong inovasi berkelanjutan dalam proses dan desain.
                    </p>
                    <p class="text-gray-600 leading-relaxed">
                        Bergabung dengan kami berarti menjadi bagian dari keluarga yang menghargai keseimbangan kehidupan kerja, pengembangan keterampilan, dan memberikan kesempatan untuk berpartisipasi dalam pelestarian warisan budaya Indonesia sambil berkembang di pasar global.
                    </p>
                </div>
                <div class="bg-gradient-to-br from-mebelgreen/10 to-mebeldark/10 p-8 rounded-3xl">
                    <div class="space-y-6">
                        <div>
                            <h4 class="text-lg font-semibold text-mebelgreen mb-2">Mengapa Bergabung Dengan Kami</h4>
                            <ul class="space-y-2 text-gray-600">
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-mebelgreen mr-3 mt-1"></i>
                                    Kesempatan belajar dari pengrajin ahli dan master kayu berpengalaman
                                </li>
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-mebelgreen mr-3 mt-1"></i>
                                    Program pelatihan dan pengembangan profesional berkelanjutan
                                </li>
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-mebelgreen mr-3 mt-1"></i>
                                    Lingkungan kerja yang inklusif dan mendukung kreativitas
                                </li>
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-mebelgreen mr-3 mt-1"></i>
                                    Paket kompensasi kompetitif dengan berbagai tunjangan
                                </li>
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-mebelgreen mr-3 mt-1"></i>
                                    Peluang karir jangka panjang dengan jalur kenaikan yang jelas
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Lowongan Section - Updated with direct button -->
    <section id="lowongan" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl lg:text-5xl font-bold text-gray-900">
                    <span class="text-mebelgreen">Lowongan</span> Kerja
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-3xl mx-auto">
                    Temukan posisi yang tepat untuk mengembangkan bakat dan potensi Anda bersama kami
                </p>
            </div>
            
            <!-- Direct Recruitment Button -->
            <div class="text-center py-16 bg-white rounded-2xl shadow-md mb-10">
                <div class="flex flex-col items-center justify-center">
                    <i class="fas fa-briefcase text-mebelgreen text-5xl mb-6"></i>
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">Bergabunglah dengan Tim Kami</h3>
                    <p class="text-gray-600 max-w-lg mx-auto mb-8">Kami sedang mencari talenta-talenta terbaik untuk bergabung dengan Kayu Mebel Indonesia. Klik tombol di bawah untuk melihat semua posisi yang tersedia dan melamar sekarang.</p>
                    <a href="https://recruitment-new.talenta.co/pawindo-group-0" target="_blank" class="inline-flex items-center px-8 py-4 bg-mebelgreen text-white font-semibold rounded-full shadow-lg hover:bg-mebeldark hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
                        <i class="fas fa-external-link-alt mr-2"></i>
                        Lihat Semua Lowongan & Lamar Sekarang
                    </a>
                </div>
            </div>
            
            <div class="text-center mt-12">
                <a href="#kontak" class="inline-flex items-center px-8 py-4 border-2 border-mebelgreen text-mebelgreen font-semibold rounded-full hover:bg-mebelgreen hover:text-white transition-all duration-300 nav-link">
                    Hubungi HR untuk Info Lebih Lanjut
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- FAQ Section - Updated to use data from database -->
    <section id="faq" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl lg:text-5xl font-bold text-gray-900">
                    <span class="text-mebelgreen">FAQ</span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-3xl mx-auto">
                    Pertanyaan yang sering ditanyakan tentang karir di Kayu Mebel Indonesia
                </p>
            </div>
            
            <div class="max-w-4xl mx-auto">
                <div class="space-y-6">
                    <?php if(count($faqs) > 0): ?>
                        <?php foreach($faqs as $index => $faq): ?>
                            <div class="bg-white border border-gray-200 rounded-2xl shadow-lg overflow-hidden card-hover">
                                <button class="w-full py-6 px-8 text-left focus:outline-none faq-button">
                                    <div class="flex items-center justify-between">
                                        <span class="text-lg font-semibold text-gray-900"><?php echo htmlspecialchars($faq['question']); ?></span>
                                        <svg class="h-6 w-6 text-mebelgreen transform transition-transform duration-300 faq-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </div>
                                </button>
                                <div class="hidden px-8 pb-6 faq-answer">
                                    <p class="text-gray-600 leading-relaxed">
                                        <?php echo nl2br(htmlspecialchars($faq['answer'])); ?>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center py-10">
                            <p class="text-gray-500">Belum ada FAQ yang tersedia.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Kontak Section - Updated to be about website feedback -->
    <section id="kontak" class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl lg:text-5xl font-bold text-gray-900">
                    Feedback <span class="text-mebelgreen">Website</span>
                </h2>
                <p class="mt-4 text-xl text-gray-600 max-w-3xl mx-auto">
                    Anda dapat meninggalkan pesan sebagai feedback kedepannya agar website berkembang dengan baik
                </p>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Contact Form -->
                <div class="lg:col-span-2">
                    <div class="bg-white p-8 rounded-2xl shadow-lg">
                        <h3 class="text-2xl font-bold text-gray-900 mb-6">Kirim Feedback</h3>
                        
                        <?php if(isset($feedback_success)): ?>
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6" role="alert">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle mr-2"></i>
                                <p>Pesan Anda telah berhasil dikirim. Terimakasih untuk feedback nya.</p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if(isset($feedback_error)): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6" role="alert">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-circle mr-2"></i>
                                <p><?php echo $feedback_error; ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <form id="feedbackForm" method="POST" action="#kontak" class="space-y-6">
                            <div>
                                <label for="name" class="block text-gray-700 font-medium mb-2">Nama Lengkap</label>
                                <input type="text" id="name" name="name" required class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-mebelgreen focus:border-transparent" placeholder="Masukkan nama lengkap Anda">
                            </div>
                            <div>
                                <label for="email" class="block text-gray-700 font-medium mb-2">Email</label>
                                <input type="email" id="email" name="email" required class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-mebelgreen focus:border-transparent" placeholder="Masukkan alamat email Anda">
                            </div>
                            <div>
                                <label for="message" class="block text-gray-700 font-medium mb-2">Pesan / Saran</label>
                                <textarea id="message" name="message" rows="6" required class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-mebelgreen focus:border-transparent" placeholder="Tuliskan pesan, saran, atau feedback Anda untuk website ini"></textarea>
                            </div>
                            <button type="submit" name="submit_feedback" id="submitBtn" class="w-full px-6 py-4 bg-mebelgreen text-white font-semibold rounded-xl shadow-lg hover:bg-mebeldark hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
                                Kirim Feedback
                            </button>
                        </form>
                    </div>
                </div>
                
                <!-- Contact Info -->
                <div class="space-y-8">
                    <div class="bg-white p-8 rounded-2xl shadow-lg">
                        <h3 class="text-xl font-bold text-gray-900 mb-6">Informasi Kontak HR</h3>
                        <div class="space-y-6">
                            <div class="flex items-start">
                                <div class="w-12 h-12 bg-mebelgreen rounded-xl flex items-center justify-center mr-4">
                                    <i class="fas fa-map-marker-alt text-white"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-900">Kantor HR</h4>
                                    <p class="text-gray-600">Jl. Mebel Indah No. 123, Sidoarjo</p>
                                    <p class="text-gray-600">Jawa Timur, Indonesia 61234</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-12 h-12 bg-mebelgreen rounded-xl flex items-center justify-center mr-4">
                                    <i class="fas fa-phone-alt text-white"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-900">Telepon Recruitment</h4>
                                    <p class="text-gray-600">+62 31 9876 5432</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-12 h-12 bg-mebelgreen rounded-xl flex items-center justify-center mr-4">
                                    <i class="fas fa-envelope text-white"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-900">Email Rekrutmen</h4>
                                    <p class="text-gray-600">karir@mebelkayusidoarjo.com</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-12 h-12 bg-mebelgreen rounded-xl flex items-center justify-center mr-4">
                                    <i class="fas fa-clock text-white"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-900">Jam Kerja HR</h4>
                                    <p class="text-gray-600">Senin - Jumat: 08.00 - 16.00 WIB</p>
                                    <p class="text-gray-600">Sabtu: 08.00 - 12.00 WIB</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-white p-8 rounded-2xl shadow-lg">
                        <h3 class="text-xl font-bold text-gray-900 mb-6">Ikuti Kami</h3>
                        <div class="flex space-x-4">
                            <a href="#" class="w-12 h-12 bg-blue-600 rounded-xl flex items-center justify-center text-white hover:bg-blue-700 transform hover:-translate-y-1 transition-all duration-300">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="w-12 h-12 bg-gradient-to-br from-purple-600 to-pink-600 rounded-xl flex items-center justify-center text-white hover:from-purple-700 hover:to-pink-700 transform hover:-translate-y-1 transition-all duration-300">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="w-12 h-12 bg-blue-400 rounded-xl flex items-center justify-center text-white hover:bg-blue-500 transform hover:-translate-y-1 transition-all duration-300">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="w-12 h-12 bg-blue-700 rounded-xl flex items-center justify-center text-white hover:bg-blue-800 transform hover:-translate-y-1 transition-all duration-300">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loading Overlay -->
        <div id="loadingOverlay" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
            <div class="bg-white p-5 rounded-xl shadow-lg flex flex-col items-center">
                <div class="w-16 h-16 border-4 border-mebelgreen border-t-transparent rounded-full animate-spin mb-4"></div>
                <p class="text-gray-700 font-medium">Mengirim pesan...</p>
            </div>
        </div>

        <!-- Success Notification -->
        <div id="successNotification" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
            <div class="bg-white p-8 rounded-xl shadow-lg flex flex-col items-center max-w-md">
                <img src="logo.jpg" alt="Mebel Kayu Logo" class="h-24 w-24 rounded-full mb-4">
                <h3 class="text-2xl font-bold text-gray-900 mb-2">Terima Kasih</h3>
                <p class="text-gray-600 text-center mb-6">Pesan Anda telah berhasil dikirim. Tim kami akan segera menghubungi Anda.</p>
                <button id="closeNotification" class="px-6 py-3 bg-mebelgreen text-white font-semibold rounded-xl shadow-lg hover:bg-mebeldark transition-all duration-300">
                    Tutup
                </button>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-mebeldark text-white py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div>
                    <div class="flex items-center mb-6">
                        <img src="logo.jpg" alt="Mebel Kayu Logo" class="h-10 w-10 rounded-full mr-3">
                        <span class="text-xl font-bold">Karir Kayu Mebel Indonesia</span>
                    </div>
                    <p class="text-gray-300 leading-relaxed">
                        Bergabunglah dengan tim kami untuk melestarikan seni kerajinan kayu tradisional dan mengembangkan karir yang menginspirasi dalam industri furniture berkualitas.
                    </p>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-6">Tautan Cepat</h4>
                    <ul class="space-y-3">
                        <li><a href="#home" class="text-gray-300 hover:text-white transition-colors duration-200 nav-link">Home</a></li>
                        <li><a href="#about" class="text-gray-300 hover:text-white transition-colors duration-200 nav-link">About</a></li>
                        <li><a href="#lowongan" class="text-gray-300 hover:text-white transition-colors duration-200 nav-link">Lowongan</a></li>
                        <li><a href="#faq" class="text-gray-300 hover:text-white transition-colors duration-200 nav-link">FAQ</a></li>
                        <li><a href="#kontak" class="text-gray-300 hover:text-white transition-colors duration-200 nav-link">Kontak</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-6">Area Karir</h4>
                    <ul class="space-y-3">
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors duration-200">Produksi</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors duration-200">Desain</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors duration-200">Marketing</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors duration-200">Quality Control</a></li>
                        <li><a href="#" class="text-gray-300 hover:text-white transition-colors duration-200">Administrasi</a></li>
                    </ul>
                </div>
            </div>
            <div class="border-t border-gray-600 mt-12 pt-8 text-center">
                <p class="text-gray-300">&copy; 2025 Kayu Mebel Indonesia. All rights reserved. Grow your career with us.</p>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="fixed bottom-6 right-6 bg-mebelgreen text-white rounded-full p-4 hidden shadow-lg hover:bg-mebeldark hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300 z-50">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
        </svg>
    </button>

    <script>
        // Store the secret code from PHP
        const secretCode = "<?php echo $secret_code; ?>";

        // Show welcome modal on page load
        document.addEventListener('DOMContentLoaded', function() {
            showWelcomeModal();
            
            // Form submission loading effect
            const feedbackForm = document.getElementById('feedbackForm');
            const loadingOverlay = document.getElementById('loadingOverlay');
            
            if (feedbackForm) {
                feedbackForm.addEventListener('submit', function() {
                    loadingOverlay.classList.remove('hidden');
                });
            }

            // Mobile menu
            const mobileMenuButton = document.querySelector('.mobile-menu-button');
            const mobileMenu = document.querySelector('.mobile-menu');

            if (mobileMenuButton) {
                mobileMenuButton.addEventListener('click', function() {
                    mobileMenu.classList.toggle('hidden');
                });
            }

            // Make the navigation links highlight based on section
            const sections = document.querySelectorAll('section');
            const navLinks = document.querySelectorAll('.nav-link');

            // Smooth scrolling for navigation links
            navLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Close mobile menu if open
                    if (mobileMenu && !mobileMenu.classList.contains('hidden')) {
                        mobileMenu.classList.add('hidden');
                    }
                    
                    const targetId = this.getAttribute('href');
                    const targetSection = document.querySelector(targetId);
                    
                    if (targetSection) {
                        window.scrollTo({
                            top: targetSection.offsetTop - 80, // Account for navbar height
                            behavior: 'smooth'
                        });
                    }
                });
            });

            // Active link based on scroll position
            function setActiveLink() {
                const scrollPosition = window.scrollY;

                sections.forEach(section => {
                    const sectionTop = section.offsetTop - 100;
                    const sectionHeight = section.offsetHeight;
                    const sectionId = section.getAttribute('id');
                    
                    if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
                        // Remove active class from all links
                        navLinks.forEach(link => {
                            if (link.getAttribute('href') === '#' + sectionId) {
                                link.classList.add('text-mebelgreen');
                                link.classList.add('border-b-2');
                                link.classList.add('border-mebelgreen');
                                link.classList.remove('text-gray-600');
                            } else {
                                link.classList.remove('text-mebelgreen');
                                link.classList.remove('border-b-2');
                                link.classList.remove('border-mebelgreen');
                                link.classList.add('text-gray-600');
                            }
                        });
                    }
                });
            }

            // Initial call to set active link
            setActiveLink();

            // Listen for scroll to update active link
            window.addEventListener('scroll', setActiveLink);

            // FAQ Accordion
            const faqButtons = document.querySelectorAll('.faq-button');
            
            faqButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const answer = this.nextElementSibling;
                    const icon = this.querySelector('.faq-icon');
                    
                    // Toggle the answer
                    answer.classList.toggle('hidden');
                    
                    // Rotate the icon
                    if (answer.classList.contains('hidden')) {
                        icon.style.transform = 'rotate(0deg)';
                    } else {
                        icon.style.transform = 'rotate(180deg)';
                    }
                });
            });

            // Back to top button
            const backToTopButton = document.getElementById('backToTop');
            
            function toggleBackToTopButton() {
                if (window.pageYOffset > 300) {
                    backToTopButton.classList.remove('hidden');
                } else {
                    backToTopButton.classList.add('hidden');
                }
            }
            
            // Initial check
            toggleBackToTopButton();
            
            // Listen for scroll
            window.addEventListener('scroll', toggleBackToTopButton);
            
            // Scroll to top when button is clicked
            backToTopButton.addEventListener('click', function() {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });

            // Add animation on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -100px 0px'
            };

            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-fade-in');
                    }
                });
            }, observerOptions);

            // Observe all cards
            const cards = document.querySelectorAll('.card-hover');
            cards.forEach(card => observer.observe(card));
        });

        // Function to show welcome modal
        function showWelcomeModal() {
            const modal = document.getElementById('welcomeModal');
            modal.style.display = 'block';
            document.body.style.overflow = 'hidden';
        }

        // Function to close welcome modal
        function closeWelcomeModal() {
            const modal = document.getElementById('welcomeModal');
            modal.style.display = 'none';
            document.body.style.overflow = '';
        }

        // Function to show login key modal
        function showLoginKeyModal() {
            const modal = document.getElementById('loginKeyModal');
            modal.style.display = 'block';
            document.body.style.overflow = 'hidden';
            document.getElementById('keyError').classList.add('hidden');
            document.getElementById('secretKey').value = '';
        }

        // Function to close login key modal
        function closeLoginKeyModal() {
            const modal = document.getElementById('loginKeyModal');
            modal.style.display = 'none';
            document.body.style.overflow = '';
        }

        // Function to check secret key
        function checkSecretKey() {
            const enteredKey = document.getElementById('secretKey').value;
            if (enteredKey === secretCode) {
                // Redirect to login page
                window.location.href = 'login.php';
            } else {
                // Show error message
                document.getElementById('keyError').classList.remove('hidden');
            }
        }

        // Close modal if user clicks outside of it
        window.onclick = function(event) {
            const modals = document.getElementsByClassName('modal');
            for (let i = 0; i < modals.length; i++) {
                if (event.target == modals[i]) {
                    modals[i].style.display = 'none';
                    document.body.style.overflow = '';
                }
            }
        }
    </script>
</body>
</html>