<?php
// Include database connection
require_once "../config/connection.php";

// Check if job ID is provided
if (!isset($_GET["job_id"])) {
    echo json_encode(["success" => false, "message" => "Job ID not provided"]);
    exit();
}

$job_id = intval($_GET["job_id"]);

// Get job details from database
$query = "SELECT * FROM job_positions WHERE job_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $job_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Job not found"]);
    exit();
}

$job = $result->fetch_assoc();

// Return job details as JSON
echo json_encode(["success" => true, "job" => $job]);
?>