<!-- dashboard_applicants.php -->
<?php
// Start session and check if user is logged in
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'applicant') {
    header("Location: ../login.php");
    exit();
}

// Include database connection
require_once '../config/connection.php';

// Get applicant data from database
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM applicants WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$applicant = $result->fetch_assoc();

// Include header
include '../template_applicants/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-soft-green via-white to-medium-green">
    <!-- Welcome Card -->
    <div class="glass-effect rounded-xl shadow-lg p-6 mb-6 dashboard-card border-l-4 border-green-500">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-2xl font-bold text-green-800">Selamat Datang di Job Portal Kayu Mebel Indonesia</h2>
            <div class="p-2 rounded-full bg-green-100 text-green-600">
                <i class="fas fa-briefcase text-xl"></i>
            </div>
        </div>
        <p class="text-gray-600 mb-6">Selamat datang di sistem portal lowongan kerja Kayu Mebel Indonesia. Gunakan panel ini untuk mengelola lamaran, melihat status aplikasi, dan mengatur jadwal wawancara Anda.</p>
        <div class="border-t border-gray-200 pt-4">
            <h3 class="text-lg font-semibold text-green-700 mb-3">Info Akun Anda:</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-user text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($applicant['username']); ?></p>
                    </div>
                </div>
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-envelope text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($applicant['email']); ?></p>
                    </div>
                </div>
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-user-check text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <p class="text-lg font-medium text-green-500"><?php echo $applicant['is_active'] ? 'Aktif' : 'Tidak Aktif'; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div> 
</main>

<?php include '../template_applicants/footer.php'; ?>