<?php
// Start session and check if user is logged in
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'admin_recruitment') {
    // Return error response
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Check if job ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    // Return error response
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Job ID is required']);
    exit();
}

// Include database connection
require_once '../config/connection.php';

// Sanitize job ID
$job_id = intval($_GET['id']);

// Get job details from database
$query = "SELECT * FROM job_positions WHERE job_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $job_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    // Fetch job data
    $job = $result->fetch_assoc();
    
    // Format dates for display if needed
    if (!empty($job['created_at'])) {
        $job['created_at_formatted'] = date('d M Y H:i', strtotime($job['created_at']));
    }
    
    if (!empty($job['updated_at'])) {
        $job['updated_at_formatted'] = date('d M Y H:i', strtotime($job['updated_at']));
    }
    
    // Add some additional information if needed
    $job['job_type_display'] = getJobTypeDisplay($job['job_type']);
    $job['status_display'] = $job['is_active'] ? 'Aktif' : 'Tidak Aktif';
    
    // Return success response with job data
    header('Content-Type: application/json');
    echo json_encode($job);
    exit();
} else {
    // Return error response if job not found
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Job not found']);
    exit();
}

/**
 * Helper function to get job type display text
 */
function getJobTypeDisplay($type) {
    $types = [
        'full-time' => 'Full Time',
        'part-time' => 'Part Time',
        'contract' => 'Kontrak',
        'internship' => 'Magang'
    ];
    
    return $types[$type] ?? $type;
}
?>