<!-- buat_posisi_admin.php -->
<?php
// Start session and check if user is logged in
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'admin_recruitment') {
    header("Location: ../login.php");
    exit();
}

// Include database connection
require_once '../config/connection.php';

// Get admin data from database
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM admin_recruitment WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$admin = $result->fetch_assoc();

// Process form submission
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and sanitize inputs
    $title = trim($_POST['title']);
    $department = trim($_POST['department']);
    $description = trim($_POST['description']);
    $requirements = trim($_POST['requirements']);
    $benefits = trim($_POST['benefits']);
    $information = trim($_POST['information']);
    $job_type = $_POST['job_type'];
    $location = trim($_POST['location']);
    $lokasi_penempatan = $_POST['lokasi_penempatan'];
    $salary_range = trim($_POST['salary_range']);
    $vacancy_count = (int)$_POST['vacancy_count'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $link = trim($_POST['link']);

    // Basic validation
    if (empty($title) || empty($department) || empty($description) || 
        empty($requirements) || empty($benefits) || empty($location)) {
        $error_message = "Semua field wajib diisi!";
    } else {
        // Insert new job position
        $query = "INSERT INTO job_positions (title, department, description, requirements, 
                 benefits, information, job_type, location, lokasi_penempatan, salary_range, 
                 vacancy_count, is_active, created_by, link) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ssssssssssiiis", $title, $department, $description, $requirements, 
                          $benefits, $information, $job_type, $location, $lokasi_penempatan, 
                          $salary_range, $vacancy_count, $is_active, $user_id, $link);
        
        if ($stmt->execute()) {
            $success_message = "Job baru berhasil dibuat!";
            // Reset form fields after successful submission
            $_POST = array();
        } else {
            $error_message = "Error: " . $stmt->error;
        }
    }
}

// Include header
include '../template_recruitment/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-soft-green via-white to-medium-green">
    <div class="max-w-5xl mx-auto bg-white rounded-xl shadow-md overflow-hidden">
        <div class="bg-gradient-primary p-4 text-white">
            <h1 class="text-2xl font-bold">Buat Posisi Pekerjaan Baru</h1>
            <p class="text-sm opacity-80">Buat dan publikasikan posisi pekerjaan baru untuk proses rekrutmen</p>
        </div>

        <!-- Notification Messages -->
        <?php if (!empty($success_message)): ?>
        <div id="successAlert" class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4 mx-4 mt-4 rounded shadow-md">
            <div class="flex items-center">
                <div class="py-1">
                    <i class="fas fa-check-circle text-green-500 mr-2"></i>
                </div>
                <div>
                    <p class="font-bold">Berhasil!</p>
                    <p><?php echo $success_message; ?></p>
                </div>
                <button type="button" onclick="document.getElementById('successAlert').remove()" class="ml-auto text-green-500 hover:text-green-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <script>
            // Auto-hide success message after 4 seconds
            setTimeout(function() {
                const alert = document.getElementById('successAlert');
                if (alert) {
                    alert.classList.add('opacity-0', 'transition-opacity', 'duration-500');
                    setTimeout(function() {
                        alert.remove();
                    }, 500);
                }
            }, 4000);
            
            // Log for debugging
            console.log("Notifikasi sukses seharusnya muncul");
        </script>
        <?php endif; ?>

        <?php if (!empty($error_message)): ?>
        <div id="errorAlert" class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4 mx-4 mt-4 rounded shadow-md">
            <div class="flex items-center">
                <div class="py-1">
                    <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                </div>
                <div>
                    <p class="font-bold">Error!</p>
                    <p><?php echo $error_message; ?></p>
                </div>
                <button type="button" onclick="document.getElementById('errorAlert').remove()" class="ml-auto text-red-500 hover:text-red-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <?php endif; ?>

        <!-- Job Position Form -->
        <form method="post" action="" class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Left Column -->
                <div>
                    <div class="mb-4">
                        <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Judul Posisi *</label>
                        <input type="text" id="title" name="title" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''; ?>" required>
                    </div>

                    <div class="mb-4">
                        <label for="department" class="block text-sm font-medium text-gray-700 mb-1">Departemen *</label>
                        <input type="text" id="department" name="department" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['department']) ? htmlspecialchars($_POST['department']) : ''; ?>" required>
                    </div>

                    <div class="mb-4">
                        <label for="job_type" class="block text-sm font-medium text-gray-700 mb-1">Tipe Pekerjaan *</label>
                        <select id="job_type" name="job_type" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" required>
                            <option value="full-time" <?php echo (isset($_POST['job_type']) && $_POST['job_type'] === 'full-time') ? 'selected' : ''; ?>>Full Time</option>
                            <option value="part-time" <?php echo (isset($_POST['job_type']) && $_POST['job_type'] === 'part-time') ? 'selected' : ''; ?>>Part Time</option>
                            <option value="contract" <?php echo (isset($_POST['job_type']) && $_POST['job_type'] === 'contract') ? 'selected' : ''; ?>>Kontrak</option>
                            <option value="internship" <?php echo (isset($_POST['job_type']) && $_POST['job_type'] === 'internship') ? 'selected' : ''; ?>>Magang</option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="location" class="block text-sm font-medium text-gray-700 mb-1">Lokasi *</label>
                        <input type="text" id="location" name="location" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['location']) ? htmlspecialchars($_POST['location']) : ''; ?>" required>
                        <p class="text-xs text-gray-500 mt-1">Contoh: Jawa Timur, Jawa Tengah, dll.</p>
                    </div>

                    <div class="mb-4">
                        <label for="lokasi_penempatan" class="block text-sm font-medium text-gray-700 mb-1">Lokasi Penempatan *</label>
                        <select id="lokasi_penempatan" name="lokasi_penempatan" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" required>
                            <option value="surabaya" <?php echo (isset($_POST['lokasi_penempatan']) && $_POST['lokasi_penempatan'] === 'surabaya') ? 'selected' : ''; ?>>Surabaya</option>
                            <option value="semarang" <?php echo (isset($_POST['lokasi_penempatan']) && $_POST['lokasi_penempatan'] === 'semarang') ? 'selected' : ''; ?>>Semarang</option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="salary_range" class="block text-sm font-medium text-gray-700 mb-1">Kisaran Gaji</label>
                        <input type="text" id="salary_range" name="salary_range" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['salary_range']) ? htmlspecialchars($_POST['salary_range']) : ''; ?>" placeholder="Contoh: Rp 4.500.000 - Rp 6.000.000">
                    </div>

                    <div class="mb-4">
                        <label for="vacancy_count" class="block text-sm font-medium text-gray-700 mb-1">Jumlah Posisi</label>
                        <input type="number" id="vacancy_count" name="vacancy_count" min="1" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['vacancy_count']) ? htmlspecialchars($_POST['vacancy_count']) : '1'; ?>">
                    </div>

                    <div class="mb-4">
                        <label for="link" class="block text-sm font-medium text-gray-700 mb-1">Link Aplikasi</label>
                        <input type="url" id="link" name="link" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" 
                               value="<?php echo isset($_POST['link']) ? htmlspecialchars($_POST['link']) : ''; ?>" placeholder="https://example.com/apply">
                        <p class="text-xs text-gray-500 mt-1">URL ke halaman aplikasi perusahaan</p>
                    </div>

                    <div class="mb-4">
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="is_active" class="form-checkbox h-5 w-5 text-green-600" <?php echo (!isset($_POST['is_active']) || (isset($_POST['is_active']) && $_POST['is_active'])) ? 'checked' : ''; ?>>
                            <span class="ml-2 text-sm text-gray-700">Aktifkan Lowongan</span>
                        </label>
                    </div>
                </div>

                <!-- Right Column -->
                <div>
                    <div class="mb-4">
                        <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi *</label>
                        <textarea id="description" name="description" rows="4" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" required><?php echo isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''; ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="requirements" class="block text-sm font-medium text-gray-700 mb-1">Persyaratan *</label>
                        <textarea id="requirements" name="requirements" rows="5" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" required><?php echo isset($_POST['requirements']) ? htmlspecialchars($_POST['requirements']) : ''; ?></textarea>
                        <p class="text-xs text-gray-500 mt-1">Gunakan format list dengan awalan tanda "-" untuk setiap item</p>
                    </div>

                    <div class="mb-4">
                        <label for="benefits" class="block text-sm font-medium text-gray-700 mb-1">Benefit *</label>
                        <textarea id="benefits" name="benefits" rows="5" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500" required><?php echo isset($_POST['benefits']) ? htmlspecialchars($_POST['benefits']) : ''; ?></textarea>
                        <p class="text-xs text-gray-500 mt-1">Gunakan format list dengan awalan tanda "-" untuk setiap item</p>
                    </div>

                    <div class="mb-4">
                        <label for="information" class="block text-sm font-medium text-gray-700 mb-1">Informasi Tambahan</label>
                        <textarea id="information" name="information" rows="4" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500"><?php echo isset($_POST['information']) ? htmlspecialchars($_POST['information']) : ''; ?></textarea>
                        <p class="text-xs text-gray-500 mt-1">Informasi tambahan tentang posisi ini</p>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="mt-6 flex justify-end">
                <button type="reset" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500 mr-2">
                    <i class="fas fa-times mr-1"></i> Reset
                </button>
                <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                    <i class="fas fa-save mr-1"></i> Simpan Posisi
                </button>
            </div>
        </form>
    </div>
</main>

<?php include '../template_recruitment/footer.php'; ?>