<!-- dashboard_it.php -->
<?php
// Start session and check if user is logged in
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'admin_it') {
    header("Location: ../login.php");
    exit();
}

// Include database connection
require_once '../config/connection.php';

// Get admin data from database
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM admin_it WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$admin = $result->fetch_assoc();

// Check if this is a fresh login (from login.php)
$showWelcomeToast = false;
if (isset($_SESSION['just_logged_in']) && $_SESSION['just_logged_in'] === true) {
    $showWelcomeToast = true;
    // Remove the flag so it doesn't show again
    unset($_SESSION['just_logged_in']);
}

// Include header
include '../template_it/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-soft-blue via-white to-medium-blue">
    <!-- Welcome Card -->
    <div class="glass-effect rounded-xl shadow-lg p-6 mb-6 dashboard-card border-l-4 border-blue-500">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-2xl font-bold text-blue-800">Selamat Datang di Panel Admin IT Job Portal</h2>
            <div class="p-2 rounded-full bg-blue-100 text-blue-600">
                <i class="fas fa-server text-xl"></i>
            </div>
        </div>
        <p class="text-gray-600 mb-6">Selamat datang di sistem administrasi IT Job Portal Kayu Mebel Indonesia. Gunakan panel ini untuk mengelola pengguna, memantau aktivitas sistem, dan memastikan keamanan platform.</p>
        <div class="border-t border-gray-200 pt-4">
            <h3 class="text-lg font-semibold text-blue-700 mb-3">Info Akun Admin:</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-3">
                        <i class="fas fa-user-shield text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($admin['username']); ?></p>
                    </div>
                </div>
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-3">
                        <i class="fas fa-user text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Nama Lengkap</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($admin['fullname']); ?></p>
                    </div>
                </div>
                <div class="flex items-center p-3 bg-white rounded-lg shadow-sm hover:shadow-md transition-all">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-3">
                        <i class="fas fa-user-check text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <p class="text-lg font-medium text-blue-500"><?php echo $admin['is_active'] ? 'Aktif' : 'Tidak Aktif'; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php if ($showWelcomeToast): ?>
<script>
    // Show welcome toast for fresh login
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(() => {
            showToast('Selamat datang di Dashboard Admin IT!', 'success');
        }, 1000);
    });
</script>
<?php endif; ?>

<?php include '../template_it/footer.php'; ?>