<?php

use Illuminate\Support\Facades\Route;
use App\Services\BusinessCentralService;
use App\Services\InventoryBC;
use App\Http\Controllers\BusinessCentralController;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\AzureAuthController;
use SocialiteProviders\Manager\SocialiteWasCalled;
use Illuminate\Support\Facades\Event;
use SocialiteProviders\Microsoft\MicrosoftExtendSocialite;

Event::listen(SocialiteWasCalled::class, function ($event) {
    $event->extendSocialite('microsoft', \SocialiteProviders\Microsoft\Provider::class);
});
Route::get('/', function () {
    return redirect()->route('login');
});
Route::get('/login', [AzureAuthController::class, 'redirectToProvider'])->name('login');
Route::get('/auth/callback', [AzureAuthController::class, 'handleProviderCallback']);
Route::get('/logout', [AzureAuthController::class, 'logout'])->name('logout');

Route::middleware('bc.auth')->group(function () {
    Route::get('/bc-transfer-lines', fn(BusinessCentralService $bc) => $bc->getTransferLinesFromBC());
    Route::get('/bc-purchase-lines', fn(BusinessCentralService $bc) => $bc->getPurchaseLineFromBC());
    Route::get('/bc-price_list', fn(BusinessCentralService $bc) => $bc->getAllPurchasePrices());
    Route::get('/bc-stockkeeping', fn(BusinessCentralService $bc) => $bc->getStockkeepingFromBC());
    Route::get('/bc-PO-qty', fn(BusinessCentralService $bc) => $bc->getPurchaseQtyByItemAndLocation('BV.0006', 'CI.1010'));
    Route::get('/bc-get_PO', fn(BusinessCentralService $bc) => $bc->getPOFromBC());
    Route::get('/bc-get_meta', fn(BusinessCentralService $bc) => $bc->getMetadata());
    Route::get('/bc-get-vendor', fn(BusinessCentralService $bc) => $bc->getAllVendorsMap());
    Route::get('/po-suggestions', [BusinessCentralController::class, 'showPoSuggestions'])->name('po-suggestions');
    Route::post('/create-po', [BusinessCentralController::class, 'create'])->name('create-po');
    Route::get('/bc-get-itemledger', fn(InventoryBC $inv) => $inv->getItemLedger());
    Route::get('/bc-get-skumap', fn(InventoryBC $inv) => $inv->getSKUMapping());
    Route::post('/update-sku', [BusinessCentralController::class, 'updateSku'])->name('sku.update');
    Route::post('/upload-Stockkeeping', [BusinessCentralController::class, 'updateStockkeeping'])->name('api.stockkeeping.upload');
    Route::get('/min-max-suggestions', [BusinessCentralController::class, 'viewSkuMapping'])->name('sku-mapping');
    Route::get('/bc-get-SKULedger', fn(InventoryBC $inv) => $inv->getItemLedgerAndSkuMappingAsync());
    Route::get('/export-missing-vendor', [BusinessCentralController::class, 'exportMissingVendor'])->name('export.missing.vendor');
    Route::get('/bc-get-SKUImport', fn(InventoryBC $inv) => $inv->getSKUImport());
    Route::get('/bc-get-getItemInvenLoc', fn(InventoryBC $inv) => $inv->getItemInvenLoc());
    Route::post('/po-suggestions/refresh', [BusinessCentralController::class, 'refreshPoSuggestions'])->name('refresh.po.suggestions');
    Route::post('/min-max-suggestions/refresh', [BusinessCentralController::class, 'refreshMinMaxSuggestions'])->name('refresh.MinMax.suggestions');
    Route::patch('/bc-update-item', [BusinessCentralController::class, 'patchItemField']);
    Route::get('/check-env', function () {
        dd([
            'AZURE_CLIENT_ID' => env('AZURE_CLIENT_ID'),
            'AZURE_CLIENT_SECRET' => env('AZURE_CLIENT_SECRET'),
            'AZURE_TENANT_ID' => env('AZURE_TENANT_ID'),
        ]);
    });
    //getItemInvenLoc
}); 
