<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use App\Services\AzureAuthService;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;
use SocialiteProviders\Microsoft\Provider;
use Illuminate\Http\Request;
class AzureAuthController extends Controller
{
    protected AzureAuthService $authService;

    public function __construct(AzureAuthService $authService)
    {
        $this->authService = $authService;
    }

    public function redirectToProvider()
    {
        return Socialite::driver('microsoft')
        ->scopes(['User.Read'])
        ->redirect();
    }

    public function handleProviderCallback(Request $request)
    {
        try {
            $user = Socialite::driver('microsoft')->stateless()->user(); 
            session([
                'user' => [
                    'name' => $user->getName(),
                    'email' => $user->getEmail(),
                ],
            ]);
            return redirect('/po-suggestions');
        } catch (\Exception $e) {
            \Log::error('Socialite error: ' . $e->getMessage());
        }
    }


    public function logout()
    {
        $this->authService->clearSession();
        return redirect('/login');
    }
}

