<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use GuzzleHttp\Promise;
use GuzzleHttp\Promise\Create;
use GuzzleHttp\Promise\Utils;
class InventoryBC {
    public function getAccessToken()
    {
        $client = new Client();
        $response = $client->post("https://login.microsoftonline.com/".env('AZURE_TENANT_ID')."/oauth2/v2.0/token", [
            'form_params' => [
                'grant_type' => 'client_credentials',
                'client_id' => env('AZURE_CLIENT_ID'),
                'client_secret' => env('AZURE_CLIENT_SECRET'),
                'scope' => 'https://api.businesscentral.dynamics.com/.default'
            ]
        ]);
        $body = json_decode((string)$response->getBody(), true);

        return $body['access_token'];
    }

    public function getCompanyId($token)
    {
        $client = new Client();
        $response = $client->get("https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') . "/api/v2.0/companies", [
            'headers' => [
                'Authorization' => "Bearer {$token}",
                'Accept'        => 'application/json'
            ]
        ]);
        
        $companies = json_decode((string)$response->getBody(), true);
        $companyId = $companies['value'][0]['id'];

        return $companyId;
    }

    public function __construct()
    {
        $this->token = $this->getAccessToken();
        $this->companyId = $this->getCompanyId($this->token);
        $this->client = new Client();
    }

    // public function getItemLedgerAndSkuMappingAsync()
    // {
    //     $twoMonthsAgo = now()->subMonths(2)->format('Y-m-d');
    //     $baseUrl = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT');
    //     $company = "/ODataV4/Company('" . $this->companyId . "')";
    //     $skuFilter = urlencode("(Location eq 'CI.1010' or Location eq 'CI.1020') and Max_Inventory gt 0");
    //     $skuUrl = "$baseUrl$company/SKU_Import?\$filter={$skuFilter}";
    //     $stockFilter = urlencode("(Location eq 'CI.1010' or Location eq 'CI.1020')");
    //     $headers = [
    //         'headers' => [
    //             'Authorization' => "Bearer {$this->token}",
    //             'Accept' => 'application/json',
    //             'Prefer' => 'odata.maxpagesize=10000'
    //         ]
    //     ];

    //     $filters = [
    //         "(Location_Code eq 'CI.1010') and (Entry_Type eq 'Negative Adjmt.') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
    //         "(Location_Code eq 'CI.1010') and (Entry_Type eq 'Transfer') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
    //         "(Location_Code eq 'CI.1020') and (Entry_Type eq 'Negative Adjmt.') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
    //         "(Location_Code eq 'CI.1020') and (Entry_Type eq 'Transfer') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)"
    //     ];

    //     $promises = [
    //         'sku' => $this->client->getAsync($skuUrl, $headers),
    //     ];

    //     foreach ($filters as $i => $filter) {
    //         $encodedFilter = urlencode($filter);
    //         $ledgerSelect = urlencode("Quantity,Item_No,Base_Unit,Location_Code,Unit_of_Measure_Code,Qty_per_Unit_of_Measure");
    //         $url = "$baseUrl$company/Item_Ledger_Entries_Excel?\$filter=$encodedFilter&\$select=$ledgerSelect";
    //         $promises["ledger_$i"] = $this->client->getAsync($url, $headers);
    //     }

    //     $promises["stockkeeping"] = $this->client->getAsync(
    //         "$baseUrl$company/APIStockkeeping?\$filter=$stockFilter",
    //         $headers
    //     );

    //     $results = \GuzzleHttp\Promise\Utils::settle($promises)->wait();

    //     $ledgerData = [];
    //     $skuData = [];

    //     foreach ($results as $key => $result) {
    //         if (str_starts_with($key, 'ledger_') && $result['state'] === 'fulfilled') {
    //             $decoded = json_decode((string)$result['value']->getBody(), true);
    //             $ledgerData = array_merge($ledgerData, $decoded['value'] ?? []);
    //         }
    //     }
    //     if ($results['stockkeeping']['state'] === 'fulfilled') {
    //         $decoded = json_decode((string)$results['stockkeeping']['value']->getBody(), true);
    //         $stockkeeping = $decoded['value'] ?? [];
    //     }

    //     if ($results['sku']['state'] === 'fulfilled') {
    //         $decoded = json_decode((string)$results['sku']['value']->getBody(), true);
    //         $skuData = $decoded['value'] ?? [];
    //     } else {
    //         \Log::error('Failed to fetch SKU Mapping: ' . $results['sku']['reason']);
    //     }

    //     \Log::info('SKU count: ' . count($skuData));
    //     \Log::info('Ledger count: ' . count($ledgerData));

    //     $ledgerQuantities = [];

    //     foreach ($ledgerData as $entry) {
    //         $itemNo = $entry['Item_No'];
    //         $location = $entry['Location_Code'];
    //         $key = $itemNo . '|' . $location;

    //         $qty = abs(floatval($entry['Quantity'] ?? 0)) * ($entry['Qty_per_Unit_of_Measure'] ?? 1);

    //         if (!isset($ledgerQuantities[$key])) {
    //             $ledgerQuantities[$key] = 0;
    //         }
    //         $ledgerQuantities[$key] += $qty;
    //     }
    //     $result = [];
    //     foreach ($skuData as $sku) {
    //         $itemNo = $sku['Item_No'];
    //         $stockFor = intval($sku['Stock_For'] ?? 0);
    //         if ($stockFor === 0) {
    //             $stockFor = 30;
    //         }
    //         $leadTime = intval($sku['Lead_Time'] ?? 0);

    //         $key = $itemNo . '|' . $sku['Location'];
    //         $consumption = $ledgerQuantities[$key] ?? 0;

    //         $matchedStock = collect($stockkeeping)
    //             ->first(fn($s) => $s['Item_No'] === $itemNo && $s['Location'] === $sku['Location']);
    //         $realMin = $matchedStock['MinInven'] ?? 0;
    //         $realMax = $matchedStock['MaxInven'] ?? 0;
    //         $lastModified = $matchedStock['LastModifiedAt'] ?? null;
    //         if ($lastModified !== null) {
    //             $lastModified = date('d F Y', strtotime($lastModified));
    //         }

    //         $suggestMin = ceil(($leadTime + 1) * ($consumption / 60));
    //         $suggestMax = ceil(($stockFor) * ($consumption / 60));
    //         $result[] = [
    //             'Item_No' => $itemNo,
    //             'Description' => $sku['Description'] ?? '',
    //             'Location' => $sku['Location'],
    //             'Stock_For' => $stockFor,
    //             'Lead Time' => $leadTime,
    //             'SuggestMinQty' => $suggestMin,
    //             'ActMinQty' => $sku['Min_Inventory'],
    //             'RealMinQty' => $realMin,
    //             'SuggestMaxQty' => $suggestMax,
    //             'ActMaxQty' => $sku['Max_Inventory'],
    //             'RealMaxQty' => $realMax,
    //             'Consumption / 2 months' => $consumption,
    //             'Comment' => $sku['Comment'],
    //             'LastModifiedAt' => $lastModified
    //         ];
    //     }
    //     return [
    //         'ledger' => $ledgerData,
    //         'sku' => $skuData,
    //         'result' => $result
    //     ];
    // }


    public function getItemLedgerAndSkuMappingAsync()
    {
        return Cache::remember('sku_mapping_cache', now()->addMinutes(120), function () {
        $twoMonthsAgo = now()->subMonths(2)->format('Y-m-d');
        $matchedKeys = [];
        $baseUrl = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT');
        $company = "/ODataV4/Company('" . $this->companyId . "')";
        $skuFilter = urlencode("(Location eq 'CI.1010' or Location eq 'CI.1020') and Max_Inventory gt 0");
        $skuUrl = "$baseUrl$company/SKU_Import?\$filter={$skuFilter}";
        $stockFilter = urlencode("(Location_Code eq 'CI.1010' or Location_Code eq 'CI.1020')");
        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept' => 'application/json',
                'Prefer' => 'odata.maxpagesize=10000'
            ]
        ];

        $filters = [
            "(Location_Code eq 'CI.1010') and (Entry_Type eq 'Negative Adjmt.') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
            "(Location_Code eq 'CI.1010') and (Entry_Type eq 'Transfer') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
            "(Location_Code eq 'CI.1020') and (Entry_Type eq 'Negative Adjmt.') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)",
            "(Location_Code eq 'CI.1020') and (Entry_Type eq 'Transfer') and (Quantity lt 0) and (Posting_Date ge $twoMonthsAgo)"
        ];

        $promises = [
            'sku' => $this->client->getAsync($skuUrl, $headers),
        ];
        
        
        foreach ($filters as $i => $filter) {
            $encodedFilter = urlencode($filter);
            $ledgerSelect = urlencode("Quantity,Item_No,Base_Unit,Location_Code,Unit_of_Measure_Code,Qty_per_Unit_of_Measure");
            $url = "$baseUrl$company/Item_Ledger_Entries_Excel?\$filter=$encodedFilter&\$select=$ledgerSelect";
            $promises["ledger_$i"] = $this->client->getAsync($url, $headers);
        }

        $promises["stockkeeping"] = $this->client->getAsync(
            "$baseUrl$company/APIStockkeeping?\$filter=$stockFilter",
            $headers
        );

        $results = \GuzzleHttp\Promise\Utils::settle($promises)->wait();

        $ledgerData = [];
        $skuData = [];

        foreach ($results as $key => $result) {
            if (str_starts_with($key, 'ledger_') && $result['state'] === 'fulfilled') {
                $decoded = json_decode((string)$result['value']->getBody(), true);
                $ledgerData = array_merge($ledgerData, $decoded['value'] ?? []);
            }
        }
        if ($results['stockkeeping']['state'] === 'fulfilled') {
            $decoded = json_decode((string)$results['stockkeeping']['value']->getBody(), true);
            $stockkeeping = $decoded['value'] ?? [];
        }

        if ($results['sku']['state'] === 'fulfilled') {
            $decoded = json_decode((string)$results['sku']['value']->getBody(), true);
            $skuData = $decoded['value'] ?? [];
        } else {
            \Log::error('Failed to fetch SKU Mapping: ' . $results['sku']['reason']);
        }

        \Log::info('SKU count: ' . count($skuData));
        \Log::info('Ledger count: ' . count($ledgerData));

        $ledgerQuantities = [];
        $ledgerBaseUnits = [];
        foreach ($ledgerData as $entry) {
            $itemNo = $entry['Item_No'];
            $location = $entry['Location_Code'];
            $key = $itemNo . '|' . $location;

            $qty = abs(floatval($entry['Quantity'] ?? 0)) * ($entry['Qty_per_Unit_of_Measure'] ?? 1);

            if (!isset($ledgerQuantities[$key])) {
                $ledgerQuantities[$key] = 0;
            }
            $ledgerQuantities[$key] += $qty;
            if (!isset($ledgerBaseUnits[$key]) && !empty($entry['Base_Unit'] ?? null)) {
        $ledgerBaseUnits[$key] = $entry['Base_Unit'];
    }
        }
        $result = [];
        foreach ($skuData as $sku) {
            $itemNo = $sku['Item_No'];
            $stockFor = intval($sku['Stock_For'] ?? 0);
            if ($stockFor === 0) {
                $stockFor = 30;
            }
            $leadTime = intval($sku['Lead_Time'] ?? 0);

            $key = $itemNo . '|' . $sku['Location'];
            $matchedKeys[$key] = true; 
            $consumption = ceil($ledgerQuantities[$key] ?? 0);

            $matchedStock = collect($stockkeeping)
                ->first(fn($s) => $s['Item_No'] === $itemNo && $s['Location_Code'] === $sku['Location']);
            $realMin = $matchedStock['MinInven'] ?? 0;
            $realMax = $matchedStock['MaxInven'] ?? 0;
            if ($realMin > 0  or $realMax > 0  or $consumption > 0) {
                $lastModified = $matchedStock['LastModifiedAt'] ?? null;
                if ($lastModified !== null) {
                    $lastModified = date('d F Y', strtotime($lastModified));
                }

                $suggestMin = ceil(($leadTime + 1) * ($consumption / 60));
                $suggestMax = ceil(($stockFor) * ($consumption / 60));
                $result[] = [
                    'Item_No' => $itemNo,
                    'Description' => $sku['Description'] ?? '',
                    'Location' => $sku['Location'],
                    'Stock_For' => $stockFor,
                    'Lead Time' => $leadTime,
                    'SuggestMinQty' => $suggestMin,
                    'ActMinQty' => $sku['Min_Inventory'],
                    'RealMinQty' => $realMin,
                    'SuggestMaxQty' => $suggestMax,
                    'ActMaxQty' => $sku['Max_Inventory'],
                    'RealMaxQty' => $realMax,
                    'Consumption / 2 months' => $consumption,
                    'Comment' => $sku['Comment'],
                    'LastModifiedAt' => $lastModified,
                    'Base_Unit_of_Measure' => $ledgerBaseUnits[$key] ?? null,
                ];
            }
            
        }
        foreach ($stockkeeping as $stock) {
            $key = $stock['Item_No'] . '|' . $stock['Location_Code'];
            if (!isset($matchedKeys[$key])) {
                $lastModified = $stock['LastModifiedAt'] ?? null;
                $consumption = ceil($ledgerQuantities[$key] ?? 0);
                if ($lastModified !== null) {
                    $lastModified = date('d F Y', strtotime($lastModified));
                }
                $realMin = $stock['MinInven'] ?? 0;
                $realMax = $stock['MaxInven'] ?? 0;
                if ($realMin > 0  or $realMax > 0  or $consumption > 0) {
                        $suggestMin = ceil((7) * ($consumption / 60));
                        $suggestMax = ceil((30) * ($consumption / 60));
                        $result[] = [
                            'Item_No' => $stock['Item_No'],
                            'Description' => $stock['Description'],
                            'Location' => $stock['Location_Code'],
                            'Stock_For' => 30,
                            'Lead Time' => 7,
                            'SuggestMinQty' => $suggestMin,
                            'ActMinQty' => 0,
                            'RealMinQty' => $stock['MinInven'] ?? 0,
                            'SuggestMaxQty' => $suggestMax,
                            'ActMaxQty' => 0,
                            'RealMaxQty' => $stock['MaxInven'] ?? 0,
                            'Consumption / 2 months' => $consumption,
                            'Comment' => '',
                            'LastModifiedAt' => $lastModified,
                            'IsMatched' => false,
                            'Base_Unit_of_Measure' => $ledgerBaseUnits[$key] ?? null,
                        ];
                    }
            }
        }
        return [
            'ledger' => $ledgerData,
            'sku' => $skuData,
            'result' => $result
        ];
        });
    }

    public function getSKUImport()
    {
        $baseUrl = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT');
        $url = "/ODataV4/Company('{$this->companyId}')/APIStockkeeping";

        $fullUrl = $baseUrl . $url;

        $response = $this->client->get($fullUrl, [
            'headers' => [
                'Authorization' => 'Bearer ' . $this->token,
                'Accept'        => 'application/json',
            ]
        ]);

        return json_decode((string) $response->getBody(), true);
    }
    
    public function getItemUOM()
    {
        $baseUrl = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT');
        $url = "/ODataV4/Company('{$this->companyId}')/Item_UOM";
        
        $fullUrl = $baseUrl . $url;

        $response = $this->client->get($fullUrl, [
            'headers' => [
                'Authorization' => 'Bearer ' . $this->token,
                'Accept'        => 'application/json',
            ]
        ]);

        return json_decode((string) $response->getBody(), true);
    }


    public function getItemIdByNo(string $itemNo)
    {
        $filter = urlencode("number eq '$itemNo'");
        $response = $this->client->get("https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
       "/api/v2.0/companies({$this->companyId})/items?\$filter=$filter", [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
            ]
        ]);

        $items = json_decode($response->getBody(), true);
        return $items['value'][0]['id'] ?? null;
    }

    public function getLocationIdByCode($locationCode)
    {
        $url = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
            "/api/v2.0/companies({$this->companyId})/locations?\$filter=code eq '{$locationCode}'";

        $response = $this->client->get($url, [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept' => 'application/json'
            ]
        ]);

        $data = json_decode((string)$response->getBody(), true);
        
        return $data['value'][0]['id'] ?? null;
    }

    public function updateSKUBuffer($itemNo, $MinStock, $MaxStock, $stockFor, $leadTime, $comment, $userName)
    {   
        set_time_limit(300);
        $start = microtime(true);
        $itemId = $this->getItemIdByNo($itemNo);
        $locationCode = str_contains($userName, 'titania@citbi.onmicrosoft.com') ? 'CI.1010' : 'CI.1020';
        $locationId = $this->getLocationIdByCode($locationCode);
        $payload = json_encode([
            'Min_Inventory' => (float) $MinStock,
            'Max_Inventory' => (float) $MaxStock,
            'Stock_For' => $stockFor,
            'Comment' => $comment,
            'Lead_Time' => $leadTime
        ]);
        $headers = [
            'Authorization' => "Bearer {$this->token}",
            'Accept' => 'application/json',
            'Content-Type' => 'application/json'
        ];
        $baseUrl = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT');
        $company = "/ODataV4/Company('" . $this->companyId . "')";
        $patchUrl = $baseUrl . $company . "/SKU_Import(Item_No='" . rawurlencode($itemNo) . "',Location='" . rawurlencode($locationCode) . "')";

        try {
            $response = $this->client->request('PATCH', $patchUrl, [
                'headers' => $headers,
                'body'    => $payload
            ]);
        } catch (\Exception $e) {
            Log::error("Failed to update SKU for {$itemNo} at {$locationCode}: " . $e->getMessage());
            return null;
        }

        $elapsed = microtime(true) - $start;
        Log::info("Create SKU runtime: {$elapsed} seconds");
        return json_decode($response->getBody(), true);
    }


    function getItemLedger()
    {
        $twoMonthsAgo = now()->subMonths(2)->format('Y-m-d');
        $filter = urlencode("(Location_Code eq 'CI.1010' or Location_Code eq 'CI.1020') and Entry_Type eq 'Negative Adjmt.'");
        $select = urlencode("Quantity,Item_No,Base_Unit,Location_Code,Unit_of_Measure_Code");
        // $url = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
        //     "/ODataV4/Company('" . $this->companyId . "')/Item_Ledger_Entries_Excel?\$filter={$filter}&\$select={$select}";
        $url = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/Item_Ledger_Entries_Excel?\$filter={$filter}";
        $totalCount = 0;
        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json',
                'Prefer' => 'odata.maxpagesize=5000'
            ]
        ];
        $allData = [];
        do {
            $response = $this->client->get($url, $headers);
            $decoded = json_decode((string)$response->getBody(), true);

            if (isset($decoded['value'])) {
                $allData = array_merge($allData, $decoded['value']);
            }
            
            if (isset($decoded['@odata.count'])) {
                $totalCount = $decoded['@odata.count'];
            }


            $url = $decoded['@odata.nextLink'] ?? null;
        } while ($url);
        return ['value' => $allData];
    }

    function getSKUMapping()
    {
        $filter = urlencode("(Location eq 'CI.1010' or Location eq 'CI.1020')");
        $url = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/SKU_Import?\$filter={$filter}";
    
        
        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json',
                'Prefer' => 'odata.maxpagesize=1000'
            ]
        ];
        $allData = [];
        do {
            $response = $this->client->get($url, $headers);
            $decoded = json_decode((string)$response->getBody(), true);

            if (isset($decoded['value'])) {
                $allData = array_merge($allData, $decoded['value']);
            }

            $url = $decoded['@odata.nextLink'] ?? null;
        } while ($url);
        return ['value' => $allData];
    }

    function getItemInvenLoc()
    {
        $filter = urlencode("(Location eq 'CI.1010' or Location eq 'CI.1020')");
        $url = "https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/ItemInvenLoc";
    
        
        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json',
                'Prefer' => 'odata.maxpagesize=1000'
            ]
        ];
        $allData = [];
        $response = $this->client->get($url, $headers);
        $decoded = json_decode((string)$response->getBody(), true);
        dd($decoded);
        return [$decoded];
    }
}