<!-- Footer -->
<footer class="bg-white border-t border-gray-200 mt-auto">
    <div class="container mx-auto px-6 py-4">
        <div class="flex flex-col md:flex-row justify-between items-center">
            <div class="text-center md:text-left mb-4 md:mb-0">
                <div class="flex items-center justify-center md:justify-start mb-2">
                    <img src="../images/logo.png" alt="Color Access System Logo" class="h-6 mr-2">
                    <p class="text-gray-600 text-sm">
                        Color Access System &copy; <?php echo date('Y'); ?> - Sistem peminjaman Warna Furniture
                    </p>
                </div>
            </div>
            <div class="text-sm text-gray-500 mr-16"> <!-- Ditambahkan margin-right 4rem (mr-16) -->
                borrower Panel
            </div>
        </div>
    </div>
</footer>

<script>
    // Toggle sidebar on mobile
    document.getElementById('toggleSidebar').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('-translate-x-full');
        document.getElementById('sidebar').classList.toggle('translate-x-0');
    });
    
    document.getElementById('closeSidebar').addEventListener('click', function() {
        document.getElementById('sidebar').classList.add('-translate-x-full');
        document.getElementById('sidebar').classList.remove('translate-x-0');
    });
    
    // Toggle profile dropdown
    document.getElementById('profileDropdown').addEventListener('click', function() {
        document.getElementById('profileMenu').classList.toggle('hidden');
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const profileDropdown = document.getElementById('profileDropdown');
        const profileMenu = document.getElementById('profileMenu');
        
        if (!profileDropdown.contains(event.target) && !profileMenu.contains(event.target)) {
            profileMenu.classList.add('hidden');
        }
    });
    
    // Track the currently open submenu
    let openSubmenu = null;
    
    // Toggle submenu with auto-close functionality
    function toggleSubmenu(element) {
        const submenu = element.nextElementSibling;
        const icon = element.querySelector('.fa-chevron-down, .fa-chevron-up');
        
        // If there's already an open submenu and it's not the one being clicked
        if (openSubmenu && openSubmenu !== submenu) {
            // Close the currently open submenu
            openSubmenu.classList.add('hidden');
            
            // Find the icon in the parent element of the open submenu and reset it
            const openSubmenuIcon = openSubmenu.previousElementSibling.querySelector('.fa-chevron-down, .fa-chevron-up');
            if (openSubmenuIcon) {
                openSubmenuIcon.classList.remove('fa-chevron-up');
                openSubmenuIcon.classList.add('fa-chevron-down');
            }
        }
        
        // Toggle the clicked submenu
        submenu.classList.toggle('hidden');
        icon.classList.toggle('fa-chevron-down');
        icon.classList.toggle('fa-chevron-up');
        
        // Update the currently open submenu reference
        if (submenu.classList.contains('hidden')) {
            openSubmenu = null;
        } else {
            openSubmenu = submenu;
        }
    }
    
    // Initialize - ensure all submenus are closed on page load
    document.addEventListener('DOMContentLoaded', function() {
        const submenus = document.querySelectorAll('.submenu > ul');
        submenus.forEach(function(submenu) {
            submenu.classList.add('hidden');
        });
        
        // Check if there's an active menu item that should be open
        const currentPath = window.location.pathname;
        const menuItems = document.querySelectorAll('.submenu ul li a');
        
        menuItems.forEach(function(item) {
            const itemHref = item.getAttribute('href');
            if (itemHref && currentPath.includes(itemHref)) {
                // This is the active menu item, open its parent submenu
                const parentSubmenu = item.closest('ul');
                const parentToggle = parentSubmenu.previousElementSibling;
                
                // Only open if it's actually hidden
                if (parentSubmenu.classList.contains('hidden')) {
                    toggleSubmenu(parentToggle);
                }
            }
        });
        
        // Animasi muncul untuk floating help center
        setTimeout(function() {
            document.querySelector('.help-center-floating').classList.add('animate-bounce');
            setTimeout(function() {
                document.querySelector('.help-center-floating').classList.remove('animate-bounce');
            }, 1000);
        }, 2000);
    });
    
    // Check screen size on load
    if (window.innerWidth < 1024) {
        document.getElementById('sidebar').classList.add('-translate-x-full');
    }
</script>

<style>
    /* Custom animation untuk floating button */
    @keyframes float {
        0% {
            transform: translateY(0px);
        }
        50% {
            transform: translateY(-10px);
        }
        100% {
            transform: translateY(0px);
        }
    }
    
    .help-center-floating {
        animation: float 6s ease-in-out infinite;
    }
    
    /* Definisi animate-pulse jika tidak ada di TailwindCSS */
    @keyframes pulse {
        0%, 100% {
            opacity: 1;
        }
        50% {
            opacity: .5;
        }
    }
    
    .animate-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }
    
    /* Animasi bounce */
    @keyframes bounce {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-20px);
        }
    }
    
    .animate-bounce {
        animation: bounce 0.5s ease-in-out;
    }
    
    /* Responsif untuk margin pada borrower panel */
    @media (max-width: 768px) {
        .mr-16 {
            margin-right: 2rem; /* Mengurangi margin pada layar kecil */
        }
    }
</style>
</div>
</body>
</html>