<?php
require_once "config/connection.php";

// Calculate the cutoff time (15 minutes after due time)
$cutoff_time = date('Y-m-d H:i:s', strtotime('-15 minutes'));

$query = "SELECT st.id, st.reservation_number, st.tanggal_transaksi, 
                 st.tanggal_pengembalian, b.nama_borrower,
                 COUNT(ti.id) as item_count
          FROM stock_transactions st
          JOIN borrower_users b ON st.borrower_id = b.id
          JOIN transaction_items ti ON st.id = ti.transaction_id
          WHERE st.status_peminjaman = 'Dipinjam'
          AND ti.status_waktu = 'overdue'
          AND st.tanggal_pengembalian < '$cutoff_time'
          GROUP BY st.id
          ORDER BY st.tanggal_pengembalian ASC";

$result = mysqli_query($conn, $query);
?>

<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-4xl max-h-[80vh] overflow-y-auto">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold">Overdue Transactions</h3>
                <button onclick="closeModal('overdue_modal')" class="text-gray-500 hover:text-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reservation #</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Borrower</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Borrow Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Overdue By</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php while ($row = mysqli_fetch_assoc($result)): 
                            $due_date = new DateTime($row['tanggal_pengembalian']);
                            $now = new DateTime();
                            $interval = $now->diff($due_date);
                            $overdue_text = $interval->format('%a days %h hours %i minutes');
                        ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['reservation_number']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo htmlspecialchars($row['nama_borrower']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo date('d M Y H:i', strtotime($row['tanggal_transaksi'])); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo date('d M Y H:i', strtotime($row['tanggal_pengembalian'])); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-red-600"><?php echo $overdue_text; ?></td>
                            <td class="px-6 py-4 whitespace-nowrap"><?php echo $row['item_count']; ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <button onclick="viewTransactionItems(<?php echo $row['id']; ?>)" class="text-blue-600 hover:text-blue-900">View Items</button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-6 flex justify-end">
                <button onclick="closeModal('overdue_modal')" class="px-4 py-2 bg-gray-200 rounded-md hover:bg-gray-300">Close</button>
            </div>
        </div>
    </div>
</div>