<?php
require_once "config/connection.php";

$item_id = $_POST['item_id'];

$query = "SELECT csi.*, c.component_name, mcp.code_color,
                 st.reservation_number, b.nama_borrower,
                 st.tanggal_transaksi, st.tanggal_pengembalian,
                 st.status_peminjaman, ti.kondisi_kembali,
                 ti.catatan, ti.foto_bukti, ti.foto_pengembalian
          FROM color_stock_items csi
          JOIN color_components c ON csi.component_id = c.id
          JOIN master_color_panel mcp ON csi.color_id = mcp.id
          LEFT JOIN transaction_items ti ON csi.id = ti.stock_item_id
          LEFT JOIN stock_transactions st ON ti.transaction_id = st.id
          LEFT JOIN borrower_users b ON st.borrower_id = b.id
          WHERE csi.id = $item_id";

$result = mysqli_query($conn, $query);
$item = mysqli_fetch_assoc($result);
?>

<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-2xl">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold">Item Details</h3>
                <button onclick="closeModal('item_detail_modal')" class="text-gray-500 hover:text-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            
            <div class="space-y-4">
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">Code Barang</p>
                        <p class="font-medium"><?php echo htmlspecialchars($item['kode_barang']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Stock Number</p>
                        <p class="font-medium"><?php echo $item['stock_number']; ?></p>
                    </div>
                </div>
                
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">Component</p>
                        <p class="font-medium"><?php echo htmlspecialchars($item['component_name']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Color Code</p>
                        <p class="font-medium"><?php echo htmlspecialchars($item['code_color']); ?></p>
                    </div>
                </div>
                
                <div>
                    <p class="text-sm text-gray-500">Rack Location</p>
                    <p class="font-medium"><?php echo htmlspecialchars($item['rack_no'] ?: 'N/A'); ?></p>
                </div>
                
                <div>
                    <p class="text-sm text-gray-500">Status</p>
                    <span class="px-2 py-1 rounded-full text-xs font-medium 
                        <?php 
                        switch ($item['status']) {
                            case 'Tersedia': echo 'bg-green-100 text-green-800'; break;
                            case 'Dipinjam': echo 'bg-blue-100 text-blue-800'; break;
                            case 'Rusak': echo 'bg-red-100 text-red-800'; break;
                            case 'Hilang': echo 'bg-gray-100 text-gray-800'; break;
                            case 'Expired': echo 'bg-purple-100 text-purple-800'; break;
                            case 'Renew': echo 'bg-yellow-100 text-yellow-800'; break;
                            default: echo 'bg-gray-100 text-gray-800';
                        }
                        ?>">
                        <?php echo htmlspecialchars($item['status']); ?>
                    </span>
                </div>
                
                <?php if ($item['status'] === 'Dipinjam' && $item['reservation_number']): ?>
                <div class="mt-6 border-t pt-4">
                    <h4 class="font-semibold mb-2">Borrowing Information</h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-500">Reservation #</p>
                            <p class="font-medium"><?php echo htmlspecialchars($item['reservation_number']); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Borrower</p>
                            <p class="font-medium"><?php echo htmlspecialchars($item['nama_borrower']); ?></p>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4 mt-2">
                        <div>
                            <p class="text-sm text-gray-500">Borrow Date</p>
                            <p class="font-medium"><?php echo date('d M Y H:i', strtotime($item['tanggal_transaksi'])); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Due Date</p>
                            <p class="font-medium"><?php echo date('d M Y H:i', strtotime($item['tanggal_pengembalian'])); ?></p>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($item['status'] === 'Dikembalikan' && $item['kondisi_kembali']): ?>
                <div class="mt-6 border-t pt-4">
                    <h4 class="font-semibold mb-2">Return Information</h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-500">Return Condition</p>
                            <p class="font-medium"><?php echo htmlspecialchars($item['kondisi_kembali']); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">Notes</p>
                            <p class="font-medium"><?php echo htmlspecialchars($item['catatan'] ?: 'N/A'); ?></p>
                        </div>
                    </div>
                    
                    <?php if ($item['foto_bukti']): ?>
                    <div class="mt-4">
                        <p class="text-sm text-gray-500 mb-2">Condition Photo</p>
                        <img src="<?php echo $item['foto_bukti']; ?>" alt="Condition photo" class="w-32 h-32 object-cover rounded">
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="mt-6 flex justify-end">
                <button onclick="closeModal('item_detail_modal')" class="px-4 py-2 bg-gray-200 rounded-md hover:bg-gray-300">Close</button>
            </div>
        </div>
    </div>
</div>